/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel;

import busexplorer.ApplicationIcons;
import busexplorer.panel.ActionType;
import busexplorer.panel.RefreshablePanel;
import busexplorer.panel.TablePanelActionInterface;
import busexplorer.utils.DateTimeRenderer;
import busexplorer.utils.StringVectorRenderer;
import busexplorer.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.RowFilter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.Document;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;
import tecgraf.javautils.gui.table.SortableTable;

public class TablePanelComponent<T>
extends RefreshablePanel {
    private SortableTable table;
    private JScrollPane scrollPane;
    private JPanel buttonsPanel;
    private JButton addBtn;
    private JButton editBtn;
    private JButton removeBtn;
    private List<JButton> othersBtns = new ArrayList<JButton>();
    private TablePanelActionInterface<T> addAction;
    private TablePanelActionInterface<T> editAction;
    private TablePanelActionInterface<T> removeAction;
    private List<TablePanelActionInterface<T>> othersActions = new ArrayList<TablePanelActionInterface<T>>();
    private boolean hasBtns = false;
    private boolean hasFilter = true;
    private TablePanelActionInterface<T> refreshAction;
    private JTextField filterText;
    private JButton clearButton;

    public TablePanelComponent(List<T> pInfo, ObjectTableProvider<T> pTableProvider, List<? extends TablePanelActionInterface<T>> actions) {
        this(new ObjectTableModel(pInfo, pTableProvider), actions, true);
    }

    public TablePanelComponent(ObjectTableModel<T> pTableModel, List<? extends TablePanelActionInterface<T>> actions, boolean hasFilter) {
        this.createTable(pTableModel);
        this.processActions(actions);
        this.hasFilter = hasFilter;
        this.init();
    }

    private void createTable(ObjectTableModel<T> model) {
        this.table = new SortableTable(true);
        this.table.setModel(model);
        this.table.setSelectionMode(2);
        this.table.sort(0, SortOrder.ASCENDING);
        this.table.setDefaultRenderer(Vector.class, (TableCellRenderer)new StringVectorRenderer());
        this.table.setDefaultRenderer(Date.class, (TableCellRenderer)new DateTimeRenderer());
        this.table.getSelectionModel().addListSelectionListener(new TableSelectionListener((JTable)this.table));
        DirectActionsListener l = new DirectActionsListener();
        this.table.addMouseListener((MouseListener)l);
        this.table.addKeyListener((KeyListener)l);
        this.table.adjustSize();
    }

    private void processActions(List<? extends TablePanelActionInterface<T>> actions) {
        block7: for (TablePanelActionInterface<T> action : actions) {
            action.setTablePanelComponent(this);
            switch (action.getActionType()) {
                case ADD: {
                    this.addAction = action;
                    this.addAction.setEnabled(this.addAction.abilityConditions());
                    this.addBtn = new JButton(action);
                    this.addBtn.setToolTipText(Utils.getString(this.getClass(), "add.tooltip"));
                    this.addBtn.setIcon(ApplicationIcons.ICON_ADD_16);
                    this.hasBtns = true;
                    continue block7;
                }
                case REMOVE: {
                    this.removeAction = action;
                    this.removeAction.setEnabled(false);
                    this.removeBtn = new JButton(action);
                    this.removeBtn.setToolTipText(Utils.getString(this.getClass(), "remove.tooltip"));
                    this.removeBtn.setIcon(ApplicationIcons.ICON_DELETE_16);
                    this.hasBtns = true;
                    continue block7;
                }
                case EDIT: {
                    this.editAction = action;
                    this.editAction.setEnabled(false);
                    this.editBtn = new JButton(action);
                    this.editBtn.setToolTipText(Utils.getString(this.getClass(), "edit.tooltip"));
                    this.editBtn.setIcon(ApplicationIcons.ICON_EDIT_16);
                    this.hasBtns = true;
                    continue block7;
                }
                case REFRESH: {
                    this.refreshAction = action;
                    continue block7;
                }
                case OTHER_ONLY_MULTI_SELECTION: 
                case OTHER_MULTI_SELECTION: 
                case OTHER_SINGLE_SELECTION: {
                    this.othersActions.add(action);
                    action.setEnabled(false);
                    this.othersBtns.add(new JButton(action));
                    this.hasBtns = true;
                    continue block7;
                }
            }
            this.othersActions.add(action);
            this.othersBtns.add(new JButton(action));
            this.hasBtns = true;
        }
    }

    private void init() {
        this.setLayout(new BorderLayout());
        if (this.hasFilter) {
            this.add((Component)this.getFilterPanel(), "North");
        }
        this.add((Component)this.getScrollPane(), "Center");
        if (this.hasBtns) {
            this.add((Component)this.getButtonsPanel(), "South");
        }
        this.validate();
        this.setVisible(true);
    }

    private JPanel getFilterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBC gbc = new GBC(0, 0).west().insets(10, 10, 10, 0);
        JLabel filterLabel = new JLabel(Utils.getString(this.getClass(), "filter.label"));
        panel.add((Component)filterLabel, gbc);
        this.filterText = new JTextField();
        gbc = new GBC(1, 0).insets(10).horizontal().filly();
        panel.add((Component)this.filterText, gbc);
        this.filterText.setToolTipText(Utils.getString(this.getClass(), "filter.tooltip"));
        this.clearButton = new JButton(Utils.getString(this.getClass(), "filter.clear"));
        gbc = new GBC(2, 0).east().insets(10, 0, 10, 10);
        this.clearButton.setToolTipText(Utils.getString(this.getClass(), "filter.clear.tooltip"));
        this.clearButton.setIcon(ApplicationIcons.ICON_CLEAR_16);
        panel.add((Component)this.clearButton, gbc);
        JButton refreshButton = new JButton(Utils.getString(this.getClass(), "refresh"));
        refreshButton.setAction(this.refreshAction);
        gbc = new GBC(3, 0).east().insets(10, 0, 10, 10);
        refreshButton.setToolTipText(Utils.getString(this.getClass(), "refresh.tooltip"));
        refreshButton.setIcon(ApplicationIcons.ICON_REFRESH_16);
        panel.add((Component)refreshButton, gbc);
        this.setupFilterControls();
        return panel;
    }

    private void setupFilterControls() {
        Document document = this.filterText.getDocument();
        document.addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                TablePanelComponent.this.filterTableContent();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TablePanelComponent.this.filterTableContent();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                TablePanelComponent.this.filterTableContent();
            }
        });
        this.filterText.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TablePanelComponent.this.filterText.selectAll();
            }

            @Override
            public void focusLost(FocusEvent e) {
                TablePanelComponent.this.filterText.select(0, 0);
            }
        });
        this.clearButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TablePanelComponent.this.filterText.setText("");
                TablePanelComponent.this.filterTableContent();
            }
        });
    }

    private void filterTableContent() {
        String text = this.filterText.getText();
        if (text.length() > 0) {
            this.table.setRowFilter(RowFilter.regexFilter(".*" + text + ".*", new int[0]));
        } else {
            this.table.setRowFilter(null);
        }
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane != null) {
            return this.scrollPane;
        }
        this.scrollPane = new JScrollPane((Component)this.table);
        this.scrollPane.setViewportView((Component)this.table);
        this.scrollPane.setAutoscrolls(true);
        return this.scrollPane;
    }

    private JPanel getButtonsPanel() {
        ArrayList<JButton> toMatch = new ArrayList<JButton>();
        int idx = 0;
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.add((Component)new JPanel(), new GBC(idx, 0).horizontal().insets(2));
        ++idx;
        if (this.addBtn != null) {
            this.buttonsPanel.add((Component)this.addBtn, new GBC(idx, 0).center().none().insets(2));
            ++idx;
            toMatch.add(this.addBtn);
        }
        if (this.editBtn != null) {
            this.buttonsPanel.add((Component)this.editBtn, new GBC(idx, 0).center().none().insets(2));
            ++idx;
            toMatch.add(this.editBtn);
        }
        if (this.removeBtn != null) {
            this.buttonsPanel.add((Component)this.removeBtn, new GBC(idx, 0).center().none().insets(2));
            ++idx;
            toMatch.add(this.removeBtn);
        }
        if (!this.othersBtns.isEmpty()) {
            for (JButton otherBtn : this.othersBtns) {
                this.buttonsPanel.add((Component)otherBtn, new GBC(idx, 0).center().none().insets(2));
                ++idx;
                toMatch.add(otherBtn);
            }
        }
        GUIUtils.matchPreferredSizes((JComponent[])toMatch.toArray(new JButton[toMatch.size()]));
        return this.buttonsPanel;
    }

    private void updateActionsAbilities() {
        int[] selectedRows = this.table.getSelectedRows();
        int length = selectedRows.length;
        if (this.addAction != null) {
            this.addAction.setEnabled(this.addAction.abilityConditions());
        }
        switch (length) {
            case 0: {
                if (this.removeAction != null) {
                    this.removeAction.setEnabled(false);
                }
                if (this.editAction != null) {
                    this.editAction.setEnabled(false);
                }
                for (TablePanelActionInterface<T> action : this.othersActions) {
                    if (!action.getActionType().equals((Object)ActionType.OTHER)) {
                        action.setEnabled(false);
                        continue;
                    }
                    action.setEnabled(action.abilityConditions());
                }
                break;
            }
            case 1: {
                if (this.removeAction != null) {
                    this.removeAction.setEnabled(this.removeAction.abilityConditions());
                }
                if (this.editBtn != null) {
                    this.editAction.setEnabled(this.editAction.abilityConditions());
                }
                block13: for (TablePanelActionInterface<T> action : this.othersActions) {
                    switch (action.getActionType()) {
                        case OTHER_MULTI_SELECTION: 
                        case OTHER_SINGLE_SELECTION: {
                            action.setEnabled(action.abilityConditions());
                            continue block13;
                        }
                        case OTHER_ONLY_MULTI_SELECTION: {
                            action.setEnabled(false);
                            continue block13;
                        }
                    }
                    action.setEnabled(action.abilityConditions());
                }
                break;
            }
            default: {
                if (this.removeAction != null) {
                    this.removeAction.setEnabled(this.removeAction.abilityConditions());
                }
                if (this.editAction != null) {
                    this.editAction.setEnabled(false);
                }
                block14: for (TablePanelActionInterface<T> action : this.othersActions) {
                    switch (action.getActionType()) {
                        case OTHER_SINGLE_SELECTION: {
                            action.setEnabled(false);
                            continue block14;
                        }
                        case OTHER_ONLY_MULTI_SELECTION: 
                        case OTHER_MULTI_SELECTION: {
                            action.setEnabled(action.abilityConditions());
                            continue block14;
                        }
                    }
                    action.setEnabled(action.abilityConditions());
                }
            }
        }
    }

    public void setElements(List<T> objects) {
        ObjectTableModel<T> model = this.getTableModel();
        model.setRows(objects);
        this.table.adjustSize();
    }

    public T getSelectedElement() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        int modelRow = this.table.convertRowIndexToModel(row);
        return (T)this.getTableModel().getRow(modelRow);
    }

    public List<T> getSelectedElements() {
        ArrayList<Object> selections = new ArrayList<Object>();
        for (int row : this.table.getSelectedRows()) {
            int modelRow = this.table.convertRowIndexToModel(row);
            Object object = this.getTableModel().getRow(modelRow);
            selections.add(object);
        }
        return selections;
    }

    public T removeSelectedElement() {
        int row = this.table.getSelectedRow();
        if (row < 0) {
            return null;
        }
        int modelRow = this.table.convertRowIndexToModel(row);
        return (T)this.getTableModel().remove(modelRow);
    }

    public List<T> removeSelectedElements() {
        ArrayList removed = new ArrayList();
        int[] rows = this.table.getSelectedRows();
        if (rows.length <= 0) {
            return new ArrayList();
        }
        int[] modelRows = new int[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            modelRows[i] = this.table.convertRowIndexToModel(rows[i]);
        }
        removed.addAll(this.getTableModel().removeAll(modelRows));
        return removed;
    }

    public void selectElement(T object, boolean show) {
        int index = this.getTableModel().getRows().indexOf(object);
        if (index != -1) {
            int vIndex = this.table.convertRowIndexToView(index);
            this.table.getSelectionModel().setSelectionInterval(vIndex, vIndex);
            if (!show) {
                return;
            }
            JViewport viewport = (JViewport)this.table.getParent();
            Rectangle rectangle = this.table.getCellRect(vIndex, vIndex, true);
            Point point = viewport.getViewPosition();
            rectangle.setLocation(rectangle.x - point.x, rectangle.y - point.y);
            viewport.scrollRectToVisible(rectangle);
        }
    }

    @Override
    public void refresh(ActionEvent event) {
        if (this.refreshAction != null) {
            this.refreshAction.actionPerformed(event);
        }
        this.updateActionsAbilities();
    }

    protected ObjectTableModel<T> getTableModel() {
        return (ObjectTableModel)this.table.getModel();
    }

    protected SortableTable getTable() {
        return this.table;
    }

    public void addTableMouseListener(MouseListener listener) {
        this.table.addMouseListener(listener);
    }

    public void addTableKeyListener(KeyListener listener) {
        this.table.addKeyListener(listener);
    }

    class DirectActionsListener
    extends MouseAdapter
    implements KeyListener {
        DirectActionsListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                int selectedRow = TablePanelComponent.this.table.getSelectedRow();
                int selectedColumn = TablePanelComponent.this.table.getSelectedColumn();
                if (!TablePanelComponent.this.table.isCellEditable(selectedRow, selectedColumn) && TablePanelComponent.this.editBtn != null && TablePanelComponent.this.editBtn.isEnabled()) {
                    TablePanelComponent.this.editBtn.doClick();
                }
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 127) {
                int selectedRow = TablePanelComponent.this.table.getSelectedRow();
                int selectedColumn = TablePanelComponent.this.table.getSelectedColumn();
                if (!TablePanelComponent.this.table.isCellEditable(selectedRow, selectedColumn) && TablePanelComponent.this.removeBtn != null && TablePanelComponent.this.removeBtn.isEnabled()) {
                    TablePanelComponent.this.removeBtn.doClick();
                }
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }

    class TableSelectionListener
    implements ListSelectionListener {
        private JTable table;

        public TableSelectionListener(JTable table) {
            this.table = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            TablePanelComponent.this.updateActionsAbilities();
        }
    }
}

