/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.authorizations;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public class AuthorizationRefreshAction
extends OpenBusAction<AuthorizationWrapper> {
    public AuthorizationRefreshAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get((String)(AuthorizationRefreshAction.class.getSimpleName() + ".name")));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REFRESH;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BusExplorerTask<List<AuthorizationWrapper>> task = new BusExplorerTask<List<AuthorizationWrapper>>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                this.setResult(AuthorizationWrapper.convertToInfo(AuthorizationRefreshAction.this.admin.getAuthorizations()));
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    AuthorizationRefreshAction.this.getTablePanelComponent().setElements((List)this.getResult());
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

