/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.certificates;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.certificates.CertificateWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public class CertificateRefreshAction
extends OpenBusAction<CertificateWrapper> {
    public CertificateRefreshAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get((String)(CertificateRefreshAction.class.getSimpleName() + ".name")));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REFRESH;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BusExplorerTask<List<CertificateWrapper>> task = new BusExplorerTask<List<CertificateWrapper>>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                this.setResult(CertificateWrapper.convertToInfo(CertificateRefreshAction.this.admin.getEntitiesWithCertificate()));
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CertificateRefreshAction.this.getTablePanelComponent().setElements((List)this.getResult());
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

