/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.interfaces;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.interfaces.InterfaceWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public class InterfaceDeleteAction
extends OpenBusAction<InterfaceWrapper> {
    public InterfaceDeleteAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get((String)(InterfaceDeleteAction.class.getSimpleName() + ".name")));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int option = JOptionPane.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title"), 0, 3);
        if (option != 0) {
            return;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                List interfaces = InterfaceDeleteAction.this.getTablePanelComponent().getSelectedElements();
                for (InterfaceWrapper interfaceInfo : interfaces) {
                    String interfaceName = interfaceInfo.getName();
                    InterfaceDeleteAction.this.admin.removeInterface(interfaceName);
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    InterfaceDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

