/*
 * Decompiled with CFR 0.152.
 */
package reuse.modified.logistic.client.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import reuse.modified.logistic.client.action.FrameCancelAction;
import reuse.modified.logistic.client.util.UI;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public abstract class InputDialog
extends JFrame {
    private static final ImageIcon errorIcon = UI.ERROR_ICON;
    protected JButton accept;
    protected JButton cancel;
    protected boolean cancelled = true;
    protected boolean hasError;
    private JPanel buttons;
    protected JTextPane messageText;
    private Window parentWindow;
    protected BusAdmin admin;

    public InputDialog(Window parentWindow, String title, BusAdmin admin) {
        super(title);
        this.parentWindow = parentWindow;
        this.admin = admin;
        this.messageText = new JTextPane();
        this.messageText.setFocusable(false);
        this.buttons = this.buildButtons();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public JButton getAcceptButton() {
        return this.accept;
    }

    public JButton getCancelButton() {
        return this.cancel;
    }

    public JFrame getWindow() {
        return this;
    }

    @Override
    public Window getOwner() {
        return this.parentWindow;
    }

    public void showDialog() {
        this.getContentPane().add(this.getMainPane());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent ev) {
                InputDialog.this.cancelled = true;
                InputDialog.this.dispose();
            }
        });
        this.pack();
        this.setLocationRelativeTo(this.parentWindow);
        this.setVisible(true);
    }

    private JScrollPane buildMessagePane() {
        this.messageText.setEditable(false);
        this.messageText.setBackground(this.getContentPane().getBackground());
        this.messageText.setFont(new Font("Arial", 0, 11));
        JScrollPane pane = new JScrollPane(this.messageText);
        pane.setPreferredSize(new Dimension(160, 40));
        pane.setBorder(null);
        return pane;
    }

    private JPanel getMainPane() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(12, 12, 0, 11);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.anchor = 13;
        panel.add((Component)this.buildFields(), c);
        c.insets = new Insets(0, 12, 0, 11);
        c.gridx = 0;
        c.gridy = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 1;
        c.anchor = 17;
        panel.add((Component)this.buildMessagePane(), c);
        c.insets = new Insets(0, 12, 11, 11);
        c.gridx = 0;
        c.gridy = 2;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 0;
        c.anchor = 13;
        panel.add((Component)this.buttons, c);
        return panel;
    }

    private JPanel buildButtons() {
        this.accept = new JButton(LNG.get((String)"InputDialog.confirm.button"));
        this.accept.setToolTipText(LNG.get((String)"InputDialog.confirm.tooltip"));
        this.accept.addActionListener(ev -> {
            if (this.accept()) {
                this.cancelled = false;
                this.dispose();
            }
        });
        JRootPane rp = this.getRootPane();
        rp.setDefaultButton(this.accept);
        this.cancel = new JButton(new FrameCancelAction(this){

            @Override
            public void actionPerformed(ActionEvent ev) {
                InputDialog.this.cancelled = true;
                super.actionPerformed(ev);
            }
        });
        this.cancel.setToolTipText(LNG.get((String)"InputDialog.cancel.tooltip"));
        return UI.buildButtonPanel(this.accept, this.cancel);
    }

    public void clearErrorMessage() {
        this.messageText.setText("");
        this.hasError = false;
    }

    public void setErrorMessage(String msg) {
        if (msg == null || msg.trim().length() == 0) {
            return;
        }
        this.messageText.setText("  " + msg);
        this.messageText.setCaretPosition(0);
        this.messageText.insertIcon(errorIcon);
        this.hasError = true;
    }

    public String getErrorMessage() {
        return this.messageText.getText();
    }

    public boolean hasErrorMessage() {
        return this.hasError;
    }

    protected abstract JPanel buildFields();

    protected abstract boolean accept();

    protected abstract boolean hasValidFields();
}

