/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.integrations;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.consumers.ConsumerWrapper;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.integrations.IntegrationInputDialog;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.gui.StandardDialogs;

public class IntegrationAddAction
extends OpenBusAction<IntegrationWrapper> {
    public IntegrationAddAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.ADD;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){
            private List<ConsumerWrapper> consumers;
            private List<ProviderWrapper> providers;
            private List<ContractWrapper> contracts;

            @Override
            protected void doPerformTask() throws Exception {
                this.consumers = ConsumerWrapper.convertToInfo(Application.login().extension.getConsumers());
                this.providers = ProviderWrapper.convertToInfo(Application.login().extension.getProviders());
                this.contracts = ContractWrapper.convertToInfo(Application.login().extension.getContracts());
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    String errorMessage = null;
                    if (this.consumers.size() == 0) {
                        errorMessage = IntegrationAddAction.this.getString("error.noconsumers");
                    }
                    if (this.providers.size() == 0) {
                        errorMessage = IntegrationAddAction.this.getString("error.noproviders");
                    }
                    if (this.contracts.size() == 0) {
                        errorMessage = IntegrationAddAction.this.getString("error.nocontracts");
                    }
                    if (errorMessage != null) {
                        StandardDialogs.showErrorDialog((Component)this.parentWindow, (String)IntegrationAddAction.this.getString("error.title"), (String)errorMessage);
                    } else {
                        new IntegrationInputDialog(IntegrationAddAction.this.parentWindow, IntegrationAddAction.this.getTablePanelComponent(), this.consumers, this.providers, this.contracts).showDialog();
                    }
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

