/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.integrations;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.desktop.dialog.ExceptionDialog;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import tecgraf.openbus.services.governance.v1_0.ConsumerOperations;
import tecgraf.openbus.services.governance.v1_0.ContractOperations;
import tecgraf.openbus.services.governance.v1_0.ProviderOperations;

public class IntegrationExportToXLSAction
extends OpenBusAction<IntegrationWrapper> {
    public IntegrationExportToXLSAction(Window parentWindow) {
        super(parentWindow);
        this.putValue("ShortDescription", this.getString("tooltip"));
        this.putValue("SmallIcon", ApplicationIcons.ICON_SPREADSHEET_16);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.OTHER;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        XSSFWorkbook wb = new XSSFWorkbook();
        XSSFFont headerFont = wb.createFont();
        headerFont.setBold(true);
        headerFont.setBoldweight((short)700);
        XSSFCellStyle headStyle = wb.createCellStyle();
        headStyle.setFont((Font)headerFont);
        headStyle.setVerticalAlignment((short)1);
        headStyle.setAlignment((short)2);
        XSSFSheet integrationsSheet = wb.createSheet(this.getString("sheet.name.integration"));
        XSSFSheet adjacencySheet = wb.createSheet(this.getString("sheet.name.adjacency"));
        XSSFSheet contactsSheet = wb.createSheet(this.getString("sheet.name.contacts"));
        adjacencySheet.createRow(0);
        Row contactsSheetHeader = contactsSheet.createRow(0);
        String[] contactsColumns = new String[]{this.getString("sheet.contacts.system"), this.getString("sheet.contacts.system.appcode"), this.getString("sheet.contacts.system.manageroffice"), this.getString("sheet.contacts.system.manager"), this.getString("sheet.contacts.system.supportoffice"), this.getString("sheet.contacts.system.support")};
        for (int c = 0; c < contactsColumns.length; ++c) {
            Cell cell = contactsSheetHeader.createCell(c);
            cell.setCellValue(contactsColumns[c]);
            cell.setCellStyle((CellStyle)headStyle);
        }
        Row integrationsSheetHeader = integrationsSheet.createRow(0);
        String[] columns = new String[]{this.getString("sheet.integration.system"), this.getString("sheet.integration.system.manageroffice"), this.getString("sheet.integration.contract"), this.getString("sheet.integration.provider"), this.getString("sheet.integration.type")};
        for (int c = 0; c < columns.length; ++c) {
            Cell cell = integrationsSheetHeader.createCell(c);
            cell.setCellValue(columns[c]);
            cell.setCellStyle((CellStyle)headStyle);
        }
        ArrayList visited = new ArrayList();
        final Vector matrix = new Vector();
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.Service, (Sheet)adjacencySheet, headStyle, (Sheet)integrationsSheet, visited, (Sheet)contactsSheet, contactsColumns, columns, wb){
            final /* synthetic */ Sheet val$adjacencySheet;
            final /* synthetic */ XSSFCellStyle val$headStyle;
            final /* synthetic */ Sheet val$integrationsSheet;
            final /* synthetic */ List val$visited;
            final /* synthetic */ Sheet val$contactsSheet;
            final /* synthetic */ String[] val$contactsColumns;
            final /* synthetic */ String[] val$columns;
            final /* synthetic */ XSSFWorkbook val$wb;
            {
                this.val$adjacencySheet = sheet;
                this.val$headStyle = xSSFCellStyle;
                this.val$integrationsSheet = sheet2;
                this.val$visited = list;
                this.val$contactsSheet = sheet3;
                this.val$contactsColumns = stringArray;
                this.val$columns = stringArray2;
                this.val$wb = xSSFWorkbook;
                super(context);
            }

            @Override
            protected void doPerformTask() throws Exception {
                int c;
                List providers = Application.login().extension.getProviders();
                List consumers = Application.login().extension.getConsumers();
                List contracts = Application.login().extension.getContracts();
                matrix.addAll(providers.parallelStream().map(ProviderOperations::name).collect(Collectors.toList()));
                matrix.addAll(consumers.parallelStream().map(ConsumerOperations::name).collect(Collectors.toList()));
                matrix.addAll(contracts.parallelStream().map(ContractOperations::name).collect(Collectors.toList()));
                for (int i = 0; i < matrix.size(); ++i) {
                    Cell hcell = this.val$adjacencySheet.getRow(0).createCell(i + 1);
                    hcell.setCellValue((String)matrix.get(i));
                    hcell.setCellStyle((CellStyle)this.val$headStyle);
                    Cell vcell = this.val$adjacencySheet.createRow(i + 1).createCell(0);
                    vcell.setCellValue((String)matrix.get(i));
                    vcell.setCellStyle((CellStyle)this.val$headStyle);
                    for (int j = 0; j < matrix.size(); ++j) {
                        this.val$adjacencySheet.getRow(i + 1).createCell(j + 1).setCellValue(0.0);
                    }
                }
                Application.login().extension.getIntegrations().forEach(integration -> Arrays.stream(integration.contracts()).forEach(contract -> {
                    int consumerIndex = matrix.indexOf(integration.consumer().name());
                    int providerIndex = matrix.indexOf(integration.provider().name());
                    int contractIndex = matrix.indexOf(contract.name());
                    this.val$adjacencySheet.getRow(consumerIndex + 1).getCell(contractIndex + 1).setCellValue(1.0);
                    this.val$adjacencySheet.getRow(contractIndex + 1).getCell(providerIndex + 1).setCellValue(1.0);
                    Row row = this.val$integrationsSheet.createRow(this.val$integrationsSheet.getLastRowNum() + 1);
                    this.val$visited.add(integration.consumer().name());
                    row.createCell(0).setCellValue(integration.consumer().name());
                    row.createCell(1).setCellValue(integration.consumer().manageroffice());
                    row.createCell(2).setCellValue(contract.name());
                    row.createCell(3).setCellValue(integration.provider().name());
                    if (providers.stream().anyMatch(provider -> provider.name().equals(integration.consumer().name()))) {
                        row.createCell(4).setCellValue(IntegrationExportToXLSAction.this.getString("sheet.integration.type.both"));
                    } else {
                        row.createCell(4).setCellValue(IntegrationExportToXLSAction.this.getString("sheet.integration.type.onlyconsumer"));
                    }
                }));
                consumers.forEach(consumer -> {
                    String consumerName = consumer.name();
                    Row contactRow = this.val$contactsSheet.createRow(matrix.indexOf(consumerName) + 1);
                    contactRow.createCell(0).setCellValue(consumerName);
                    contactRow.createCell(1).setCellValue(consumer.code());
                    contactRow.createCell(2).setCellValue(consumer.manageroffice());
                    contactRow.createCell(3).setCellValue(String.join((CharSequence)",", consumer.manager()));
                    contactRow.createCell(4).setCellValue(consumer.supportoffice());
                    contactRow.createCell(5).setCellValue(String.join((CharSequence)",", consumer.support()));
                });
                providers.forEach(provider -> {
                    String providerName = provider.name();
                    Row contactRow = this.val$contactsSheet.createRow(matrix.indexOf(providerName) + 1);
                    contactRow.createCell(0).setCellValue(providerName);
                    contactRow.createCell(1).setCellValue(provider.code());
                    contactRow.createCell(2).setCellValue(provider.manageroffice());
                    contactRow.createCell(3).setCellValue(String.join((CharSequence)",", provider.manager()));
                    contactRow.createCell(4).setCellValue(provider.supportoffice());
                    contactRow.createCell(5).setCellValue(String.join((CharSequence)",", provider.support()));
                    Arrays.stream(provider.contracts()).forEach(contract -> {
                        int contractIndex = matrix.indexOf(contract.name());
                        int providerIndex = matrix.indexOf(providerName);
                        this.val$adjacencySheet.getRow(contractIndex + 1).getCell(providerIndex + 1).setCellValue(1.0);
                    });
                    if (!this.val$visited.contains(providerName)) {
                        Row row = this.val$integrationsSheet.createRow(this.val$integrationsSheet.getLastRowNum() + 1);
                        row.createCell(0).setCellValue(providerName);
                        row.createCell(1).setCellValue(provider.manageroffice());
                        row.createCell(4).setCellValue(IntegrationExportToXLSAction.this.getString("sheet.integration.type.onlyprovider"));
                    }
                });
                for (c = 0; c < this.val$contactsColumns.length; ++c) {
                    this.val$contactsSheet.autoSizeColumn(c);
                }
                for (c = 0; c < this.val$columns.length; ++c) {
                    this.val$integrationsSheet.autoSizeColumn(c);
                }
                for (c = 0; c < matrix.size(); ++c) {
                    this.val$adjacencySheet.autoSizeColumn(c);
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    JFileChooser chooser = new JFileChooser(){

                        @Override
                        protected JDialog createDialog(Component var1) throws HeadlessException {
                            JDialog dialog = super.createDialog(var1);
                            dialog.setMinimumSize(new Dimension(800, 600));
                            return dialog;
                        }

                        @Override
                        public void approveSelection() {
                            if (this.getSelectedFile().exists() && this.getDialogType() == 1 && InputDialog.showConfirmDialog(parentWindow, IntegrationExportToXLSAction.this.getString("replace.message"), IntegrationExportToXLSAction.this.getString("replace.title")) != 0) {
                                return;
                            }
                            super.approveSelection();
                        }
                    };
                    chooser.setFileFilter(new FileNameExtensionFilter(IntegrationExportToXLSAction.this.getString("export.extensionfilter.name"), "xlsx"));
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.setFileSelectionMode(0);
                    int status = chooser.showSaveDialog(this.parentWindow);
                    if (status == 0) {
                        String filename = chooser.getSelectedFile().getAbsolutePath();
                        if (!chooser.getSelectedFile().exists() && !filename.endsWith(".xlsx")) {
                            filename = filename + ".xlsx";
                        }
                        try {
                            FileOutputStream fileOut = new FileOutputStream(filename);
                            this.val$wb.write((OutputStream)fileOut);
                            fileOut.flush();
                            fileOut.close();
                            JOptionPane.showMessageDialog(this.parentWindow, Language.get(IntegrationExportToXLSAction.class, "export.success", filename), IntegrationExportToXLSAction.this.getString("export.success.title"), 1);
                        }
                        catch (Exception e) {
                            ExceptionDialog.createDialog(this.parentWindow, IntegrationExportToXLSAction.this.getString("export.error"), e, "").setVisible(true);
                        }
                    }
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

