/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.integrations;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.consumers.ConsumerWrapper;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.services.governance.v1_0.Integration;

public class IntegrationInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel consumerLabel;
    private JComboBox consumerCombo;
    private JLabel providerLabel;
    private JComboBox providerCombo;
    private JLabel contractLabel;
    private JList<String> contractList;
    private JLabel activationLabel;
    private JCheckBox activationBox;
    private JLabel contractValidationLabel;
    private JCheckBox contractValidationBox;
    private TreeMap<String, ConsumerWrapper> consumers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TreeMap<String, ProviderWrapper> providers = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TreeMap<String, ContractWrapper> contracts = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private TablePanelComponent<IntegrationWrapper> panel;
    private IntegrationWrapper editingIntegration = null;

    public IntegrationInputDialog(Window parentWindow, TablePanelComponent<IntegrationWrapper> panel, List<ConsumerWrapper> consumers, List<ProviderWrapper> providers, List<ContractWrapper> contracts) {
        super(parentWindow);
        this.panel = panel;
        for (ConsumerWrapper consumer : consumers) {
            this.consumers.put(consumer.name(), consumer);
        }
        for (ProviderWrapper provider : providers) {
            this.providers.put(provider.name(), provider);
        }
        for (ContractWrapper contract : contracts) {
            this.contracts.put(contract.name(), contract);
        }
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                if (IntegrationInputDialog.this.editingIntegration == null) {
                    Integration integration = Application.login().extension.getIntegrationRegistry().add();
                    integration.consumer(Application.login().extension.getConsumerRegistry().get(IntegrationInputDialog.this.getConsumerSelected().name()));
                    integration.provider(Application.login().extension.getProviderRegistry().get(IntegrationInputDialog.this.getProviderSelected().name()));
                    integration.activated(IntegrationInputDialog.this.getActivation().booleanValue());
                    ArrayList<String> changes = new ArrayList<String>();
                    for (String contract : IntegrationInputDialog.this.getContractNameSelected()) {
                        if (integration.addContract(contract)) continue;
                        if (IntegrationInputDialog.this.shouldAddContractToProvider()) {
                            if (!integration.provider().addContract(contract)) {
                                for (String revert : changes) {
                                    integration.provider().removeContract(revert);
                                }
                                Application.login().extension.getIntegrationRegistry().remove(integration.id());
                                throw new IllegalArgumentException(Language.get(IntegrationInputDialog.class, "error.provider.doesnt.support.contract", contract));
                            }
                            changes.add(contract);
                            if (integration.addContract(contract)) continue;
                            Application.login().extension.getIntegrationRegistry().remove(integration.id());
                            throw new IllegalStateException(Language.get(IntegrationInputDialog.class, "error.couldntaddcontracts", contract));
                        }
                        Application.login().extension.getIntegrationRegistry().remove(integration.id());
                        throw new IllegalArgumentException(Language.get(IntegrationInputDialog.class, "error.provider.doesnt.support.contract", contract));
                    }
                    IntegrationInputDialog.this.editingIntegration = new IntegrationWrapper(integration);
                } else {
                    try {
                        IntegrationInputDialog.this.editingIntegration.contracts(IntegrationInputDialog.this.getContractNameSelected(), IntegrationInputDialog.this.shouldAddContractToProvider());
                    }
                    catch (IllegalArgumentException e) {
                        throw new IllegalArgumentException(Language.get(IntegrationInputDialog.class, "error.provider.doesnt.support.contract", e.getMessage()), e);
                    }
                    catch (IllegalStateException e) {
                        throw new IllegalStateException(Language.get(IntegrationInputDialog.class, "error.couldntaddcontracts", e.getMessage()), e);
                    }
                    IntegrationInputDialog.this.editingIntegration.consumer(IntegrationInputDialog.this.getConsumerSelected());
                    IntegrationInputDialog.this.editingIntegration.provider(IntegrationInputDialog.this.getProviderSelected());
                    IntegrationInputDialog.this.editingIntegration.activate(IntegrationInputDialog.this.getActivation());
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    IntegrationInputDialog.this.panel.refresh(null);
                    IntegrationInputDialog.this.panel.selectElement(IntegrationInputDialog.this.editingIntegration, true);
                }
            }
        };
        task.execute(this, this.getString("waiting.title"), this.getString("waiting.msg"));
        return task.getStatus();
    }

    @Override
    protected JPanel buildFields() {
        this.setMinimumSize(new Dimension(550, 400));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, flowy"));
        this.consumerLabel = new JLabel(Language.get(this.getClass(), "consumer.label"));
        panel.add((Component)this.consumerLabel, "grow");
        this.consumerCombo = new JComboBox<String>(this.consumers.keySet().toArray(new String[this.consumers.size()]));
        panel.add((Component)this.consumerCombo, "grow");
        this.providerLabel = new JLabel(Language.get(this.getClass(), "provider.label"));
        panel.add((Component)this.providerLabel, "grow");
        this.providerCombo = new JComboBox<String>(this.providers.keySet().toArray(new String[this.providers.size()]));
        panel.add((Component)this.providerCombo, "grow");
        this.contractLabel = new JLabel(Language.get(this.getClass(), "contracts.label"));
        panel.add((Component)this.contractLabel, "grow");
        this.contractList = new JList<String>(this.contracts.keySet().toArray(new String[this.contracts.size()]));
        this.contractList.setSelectionMode(2);
        this.contractList.setVisibleRowCount(8);
        this.contractList.addListSelectionListener(listener -> {
            if (listener.getFirstIndex() != -1 && listener.getLastIndex() != -1) {
                this.clearErrorMessage();
            }
        });
        panel.add((Component)new JScrollPane(this.contractList), "grow, push");
        JPanel checkBoxesGroup = new JPanel((LayoutManager)new MigLayout("fill, ins 0, flowx"));
        this.activationBox = new JCheckBox();
        this.activationBox.setSelected(false);
        checkBoxesGroup.add(this.activationBox);
        this.activationLabel = new JLabel(Language.get(this.getClass(), "activated.label"));
        checkBoxesGroup.add((Component)this.activationLabel, "grow, wrap");
        this.activationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                IntegrationInputDialog.this.activationBox.setSelected(!IntegrationInputDialog.this.activationBox.isSelected());
            }
        });
        this.contractValidationBox = new JCheckBox();
        this.contractValidationBox.setSelected(false);
        checkBoxesGroup.add(this.contractValidationBox);
        this.contractValidationLabel = new JLabel(Language.get(this.getClass(), "contractvalidation.label"));
        checkBoxesGroup.add((Component)this.contractValidationLabel, "grow");
        this.contractValidationLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                IntegrationInputDialog.this.contractValidationBox.setSelected(!IntegrationInputDialog.this.contractValidationBox.isSelected());
            }
        });
        panel.add(checkBoxesGroup);
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.getConsumerSelected() == null) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.consumer"));
            this.consumerCombo.addActionListener(al -> this.clearErrorMessage());
            return false;
        }
        if (this.getProviderSelected() == null) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.provider"));
            this.providerCombo.addActionListener(al -> this.clearErrorMessage());
            return false;
        }
        if (this.getContractNameSelected().size() == 0) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.contracts"));
            this.contractList.addListSelectionListener(listener -> {
                if (listener.getFirstIndex() != -1 && listener.getLastIndex() != -1) {
                    this.clearErrorMessage();
                }
            });
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(IntegrationWrapper info) {
        this.editingIntegration = info;
        this.consumerCombo.setSelectedItem(info.consumer());
        this.providerCombo.setSelectedItem(info.provider());
        this.activationBox.setSelected(info.isActivated());
        List<String> updated = info.contracts();
        if (updated.size() > 0) {
            this.contractList.setSelectedValue(updated.get(0), true);
            int[] indices = new int[updated.size()];
            int i = 0;
            int k = 0;
            for (String c : this.contracts.keySet()) {
                if (updated.contains(c)) {
                    indices[k] = i;
                    ++k;
                }
                ++i;
            }
            this.contractList.setSelectedIndices(indices);
        }
    }

    private ConsumerWrapper getConsumerSelected() {
        return this.consumers.get(this.consumerCombo.getSelectedItem());
    }

    private ProviderWrapper getProviderSelected() {
        return this.providers.get(this.providerCombo.getSelectedItem());
    }

    private List<String> getContractNameSelected() {
        return this.contractList.getSelectedValuesList();
    }

    private boolean shouldAddContractToProvider() {
        return this.contractValidationBox.isSelected();
    }

    private Boolean getActivation() {
        return this.activationBox.isSelected();
    }
}

