package busexplorer.panel.authorizations;

import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * Classe que detm as informaes locais da autorizao para apresentao em
 * tabelas.
 * 
 * @author Tecgraf
 */
public class AuthorizationWrapper {
  /** objeto descritor de entidade autorizada */
  private RegisteredEntityDesc desc;

  /** Identificador da entidade autorizada */
  private final String id;
  /** Interface */
  private final String interfaceName;

  /**
   * Construtor.
   * 
   * @param desc descritor da entidade autorizada
   * @param interfaceName nome da interface a ser autorizada
   */
  public AuthorizationWrapper(RegisteredEntityDesc desc, String interfaceName) {
    this.desc = desc;
    this.id = desc.id;
    this.interfaceName = interfaceName;
  }

  /**
   * Compara um objeto  instncia de {@link AuthorizationWrapper}.
   *
   * O mtodo no leva em considerao o objeto descritor da autorizao.
   * 
   * @param o Objeto a ser comparado.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AuthorizationWrapper)) {
      return false;
    }
    AuthorizationWrapper other = (AuthorizationWrapper) o;
    return id.equals(other.id) && interfaceName.equals(other.interfaceName);
  }

  /**
   * Cdigo hash do objeto.
   *
   * @return Cdigo hash do objeto.
   */
  @Override
  public int hashCode() {
    return id.hashCode() ^ interfaceName.hashCode();
  }

  /**
   * Recupera a interface.
   * 
   * @return a interface.
   */
  public String getInterface() {
    return interfaceName;
  }

  /**
   * Recupera o identificador da entidade autorizada.
   * 
   * @return o identificador da entidade autorizada.
   */
  public String getEntityId() {
    return id;
  }

  /**
   * Recupera o objeto descritor da entidade autorizada.
   *
   * @return o objeto descritor da entidade autorizada.
   */
  public RegisteredEntityDesc getEntityDescriptor() {
    return desc;
  }

  /**
   * Mtodo utilitrio para converter um mapa de autorizaes em uma lista de
   * {@link AuthorizationWrapper}
   * 
   * @param authorizationsMap o mapa de autorizaes
   * @return a lista de {@link AuthorizationWrapper}
   */
  public static List<AuthorizationWrapper> convertToInfo(Map<RegisteredEntityDesc,
    List<String>> authorizationsMap) {
    List<AuthorizationWrapper> list = new ArrayList<>();
    for (Map.Entry<RegisteredEntityDesc, List<String>> authorizations :
      authorizationsMap.entrySet()) {
      RegisteredEntityDesc entity = authorizations.getKey();
      for (String interfaceName : authorizations.getValue()) {
        list.add(new AuthorizationWrapper(entity, interfaceName));
      }
    }

    return list;
  }

}
