package busexplorer.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

/**
 * Propriedades de configurao do BusExplorer.
 *
 * As propriedades de configurao, por padro, so obtidas do arquivo
 * "busexplorer.conf" presente no prprio diretrio de execuo. O usurio pode
 * especificar um arquivo em particular atravs da propriedade "configPath".
 *
 * @author Tecgraf
 */
public class ConfigurationProperties extends Properties {
  /**
   * Construtor.
   */
  public ConfigurationProperties() {
    try {
      String configPath = System.getProperty("configPath") != null ?
        System.getProperty("configPath") : "busexplorer.conf";

      FileInputStream configStream = new FileInputStream(configPath);
      load(configStream);
    }
    catch (FileNotFoundException e) {
      System.err.println(Language.get(this.getClass(),
        "warning.configFileNotFound"));
    }
    catch (IOException e) {
      System.err.println(Language.get(this.getClass(),
        "warning.configFileLoadFailure"));
    }
  }
}
