/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.algorithmservice.v1_1;

import java.io.IOException;
import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import tecgraf.openbus.algorithmservice.v1_1.FTCFileHelper;
import tecgraf.openbus.algorithmservice.v1_1.Program;
import tecgraf.openbus.algorithmservice.v1_1.ProgramHelper;
import tecgraf.openbus.algorithmservice.v1_1.Version;

public abstract class VersionHelper {
    private static volatile TypeCode _type;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TypeCode type() {
        if (_type != null) return _type;
        Class<VersionHelper> clazz = VersionHelper.class;
        synchronized (VersionHelper.class) {
            if (_type != null) return _type;
            _type = ORB.init().create_struct_tc(VersionHelper.id(), "Version", new StructMember[]{new StructMember("major", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("minor", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("patch", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("stringValue", ORB.init().create_string_tc(0), null), new StructMember("configFile", ORB.init().create_struct_tc(FTCFileHelper.id(), "FTCFile", new StructMember[]{new StructMember("id", ORB.init().create_sequence_tc(0, ORB.init().get_primitive_tc(TCKind.from_int((int)10))), null), new StructMember("host", ORB.init().create_string_tc(0), null), new StructMember("port", ORB.init().get_primitive_tc(TCKind.from_int((int)3)), null), new StructMember("key", ORB.init().create_sequence_tc(0, ORB.init().get_primitive_tc(TCKind.from_int((int)10))), null)}), null), new StructMember("programs", ORB.init().create_sequence_tc(0, ORB.init().create_struct_tc(ProgramHelper.id(), "Program", new StructMember[]{new StructMember("name", ORB.init().create_string_tc(0), null), new StructMember("requirements", ORB.init().create_sequence_tc(0, ORB.init().create_string_tc(0)), null)})), null)});
            // ** MonitorExit[var0] (shouldn't be in output)
            return _type;
        }
    }

    public static void insert(Any any, Version s) {
        any.type(VersionHelper.type());
        VersionHelper.write(any.create_output_stream(), s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Version extract(Any any) {
        InputStream in = any.create_input_stream();
        try {
            Version version = VersionHelper.read(in);
            return version;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException("Unexpected exception " + e.toString());
            }
        }
    }

    public static String id() {
        return "IDL:tecgraf/openbus/algorithmservice/v1_1/Version:1.0";
    }

    public static Version read(InputStream in) {
        Version result = new Version();
        result.major = in.read_long();
        result.minor = in.read_long();
        result.patch = in.read_long();
        result.stringValue = in.read_string();
        result.configFile = FTCFileHelper.read(in);
        int _lresult_programs5 = in.read_long();
        try {
            int x = in.available();
            if (x > 0 && _lresult_programs5 > x) {
                throw new MARSHAL("Sequence length too large. Only " + x + " available and trying to assign " + _lresult_programs5);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        result.programs = new Program[_lresult_programs5];
        for (int i = 0; i < result.programs.length; ++i) {
            result.programs[i] = ProgramHelper.read(in);
        }
        return result;
    }

    public static void write(OutputStream out, Version s) {
        out.write_long(s.major);
        out.write_long(s.minor);
        out.write_long(s.patch);
        String tmpResult12 = s.stringValue;
        out.write_string(tmpResult12);
        FTCFileHelper.write(out, s.configFile);
        out.write_long(s.programs.length);
        for (int i = 0; i < s.programs.length; ++i) {
            ProgramHelper.write(out, s.programs[i]);
        }
    }
}

