/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import java.util.Vector;
import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;
import tecgraf.openbus.algorithmservice.v1_1.InvalidParameterException;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationItem;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationParameter;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationParameterHelper;

public class EnumerationParameterImpl
extends EnumerationParameter {
    private Vector<EnumerationItem> vectorItems = new Vector();

    public EnumerationParameterImpl() {
        this.selectedId = "";
    }

    public EnumerationParameterImpl(String selectedId) {
        this.selectedId = selectedId;
    }

    @Override
    public String convertToText() throws ConversionToTextException {
        if (this.selectedId == null) {
            throw new ConversionToTextException();
        }
        return this.selectedId;
    }

    @Override
    public String getIDLType() {
        return EnumerationParameterHelper.id();
    }

    public void addItem(EnumerationItem item) {
        this.vectorItems.add(item);
        this.items = this.vectorItems.toArray(new EnumerationItem[this.vectorItems.size()]);
    }

    public void setSelectedItem(String selectedId) throws InvalidParameterException {
        if (!this.validateItem(selectedId)) {
            throw new InvalidParameterException();
        }
        this.selectedId = selectedId;
    }

    private boolean validateItem(String itemId) {
        if (this.items == null) {
            return false;
        }
        if (this.items.length == 0) {
            return false;
        }
        for (EnumerationItem item : this.items) {
            if (!item.id.equals(itemId)) continue;
            return true;
        }
        return false;
    }
}

