/**
 * $Id: BooleanParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

/**
 * A classe <code>BooleanParameterImpl</code> implementa um valutype
 * <code>BooleanParameter</code>
 * 
 * @author Tecgraf
 */
public class BooleanParameterImpl extends BooleanParameter {

  /**
   * Construtor padro.
   */
  public BooleanParameterImpl() {
    this.value = false;
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param value valor do parmetro
   */
  public BooleanParameterImpl(boolean value) {
    this.value = value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() {
    return String.valueOf(value);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return BooleanParameterHelper.id();
  }
}