/**
 * $Id: DoubleParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

/**
 * A classe <code>DoubleParameterImpl</code> implementa um valutype
 * <code>DoubleParameter</code>
 * 
 * @author Tecgraf
 */
public class DoubleParameterImpl extends DoubleParameter {

  /**
   * Construtor padro.
   */
  public DoubleParameterImpl() {
    this.value = 0;
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param value valor do parmetro
   */
  public DoubleParameterImpl(double value) {
    this.value = value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() {
    return String.valueOf(value);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return DoubleParameterHelper.id();
  }
}