/**
 * $Id: FormulaParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

/**
 * A classe <code>FormulaParameterImpl</code> implementa um valutype
 * <code>FormulaParameter</code>
 * 
 * @author Tecgraf
 */
public class FormulaParameterImpl extends FormulaParameter {

  /**
   * Construtor padro.
   */
  public FormulaParameterImpl() {
    this.formula = "";
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param formula formula
   */
  public FormulaParameterImpl(String formula) {
    this.formula = formula;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() {
    return formula;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return FormulaParameterHelper.id();
  }
}