/**
 * $Id: InputFileListParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;

/**
 * A classe <code>InputFileListParameterImpl</code> implementa um valutype
 * <code>InputFileListParameter</code>
 * 
 * @author Tecgraf
 */
public class InputFileListParameterImpl extends InputFileListParameter {
  /**
   * Separador de itens da representao textual de uma lista de arquivos.
   */
  private static final String ITEM_SEPARATOR = "|";

  /**
   * Construtor padro.
   */
  public InputFileListParameterImpl() {
    this.files = new InputFileParameter[0];
  }

  /**
   * Construtor que recebe uma lista de arquivos de entrada
   * 
   * @param files lista de arquivos de entrada
   */
  public InputFileListParameterImpl(InputFileParameter[] files) {
    this.files = files;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() throws ConversionToTextException {
    StringBuffer asText = new StringBuffer();

    for (int i = 0; i < files.length; i++) {
      asText.append(files[i].convertToText());
      if (i < (files.length - 1)) {
        asText.append(ITEM_SEPARATOR);
      }
    }

    return asText.toString();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return InputFileListParameterHelper.id();
  }
}
