/**
 * $Id: OutputFileParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

/**
 * A classe <code>OutputFileParameterImpl</code> implementa um valutype
 * <code>OutputFileParameter</code>
 * 
 * @author Tecgraf
 */
public class OutputFileParameterImpl extends OutputFileParameter {

  /**
   * Construtor padro.
   */
  public OutputFileParameterImpl() {
    this.path = "";
    this.type = "";
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param path caminho do arquivo
   * @param type tipo do arquivo
   */
  public OutputFileParameterImpl(String path, String type) {
    this.path = path;
    this.type = type;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() {
    return this.path + ":" + this.type;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return OutputFileParameterHelper.id();
  }
}
