/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.domain.model;

import br.pucrio.tecgraf.soma.job.domain.model.ExitStatus;
import br.pucrio.tecgraf.soma.job.domain.model.JobSpecificationType;
import br.pucrio.tecgraf.soma.job.domain.model.StatusType;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import org.hibernate.annotations.Immutable;
import org.hibernate.annotations.Subselect;
import org.hibernate.annotations.Synchronize;

@Entity
@Immutable
@Subselect(value="SELECT j.id || '#' || jsh.id || '#' || CASE WHEN jpv.job_algo_param_id IS NULL THEN 'null' ELSE jpv.job_algo_param_id::char END as generated_view_id,j.id, j.job_id, j.group_id, j.project_id, j.user_id, j.auto_machine_selected,jsm.machine_name, j.number_of_processes,  j.number_of_processes_by_machine,j.submission_time, j.description, j.priority, j.multiple_execution, j.job_type,j.number_of_retries, j.execution_machine, j.end_time, j.exit_code,j.guilty_node_id, j.exit_status, j.cpu_time, j.wall_clock_time,    j.ram_mem, j.flow_id, j.flow_version, j.flow_name,  j.flow_raw, j.last_modified_time, j.is_deleted,jsh.id as job_statushistory_id, jsh.job_status, jsh.status_timestamp,ja.id as ja_id, ja.algo_id, ja.algo_version, ja.algo_name, jap.param_id, jap.param_label, jap.param_type,jpv.job_algo_param_id, jpv.value FROM jobs j LEFT JOIN job_selected_machines jsm ON (j.id = jsm.job_id) JOIN job_status_history jsh ON(j.id = jsh.job_id) JOIN job_algorithms ja ON (j.id = ja.job_id) LEFT JOIN job_algo_params jap ON (jap.job_algo_id = ja.id) LEFT  JOIN job_param_values jpv ON (jpv.job_algo_param_id = jap.id) ORDER BY j.id, job_statushistory_id, jpv.job_algo_param_id")
@Synchronize(value={"jobs", "job_status_history"})
public class JobView {
    @Id
    @Column(name="generated_view_id", updatable=false, nullable=false)
    private String viewId;
    @Column(name="id", nullable=false)
    private Long id;
    @Column(name="job_id", unique=true)
    private String jobId;
    @Column(name="group_id", nullable=true)
    private String groupId = null;
    @Column(name="project_id", nullable=false)
    private String projectId = null;
    @Column(name="user_id", nullable=false)
    private String jobOwner = null;
    @Column(name="auto_machine_selected", nullable=false)
    private Boolean automaticallyMachineSelection = null;
    @Column(name="machine_name", nullable=true)
    private String selectedMachine = null;
    @Column(name="number_of_processes", nullable=false)
    private Integer numberOfProcesses = 1;
    @Column(name="number_of_processes_by_machine", nullable=false)
    private Integer numberOfProcessesByMachine = 1;
    @Column(name="submission_time", nullable=false)
    private LocalDateTime submissionTime = null;
    @Column(name="description", nullable=true, length=500)
    private String description = null;
    @Column(name="priority", nullable=false)
    private Integer priority = null;
    @Column(name="multiple_execution", nullable=false)
    private Boolean multipleExecution = false;
    @Column(name="job_type", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private JobSpecificationType jobType = JobSpecificationType.ALGORITHM;
    @Column(name="number_of_retries", nullable=false)
    private Integer numberOfRetries = 0;
    @Column(name="execution_machine", nullable=true)
    private String executionMachine = null;
    @Column(name="end_time", nullable=true)
    private LocalDateTime endTime = null;
    @Column(name="exit_code", nullable=true)
    private Integer exitCode = null;
    @Column(name="guilty_node_id", nullable=true)
    private String guiltyNodeId = null;
    @Enumerated(value=EnumType.STRING)
    @Column(name="exit_status", nullable=true)
    private ExitStatus exitStatus = null;
    @Column(name="cpu_time", nullable=true)
    private Double cpuTime = null;
    @Column(name="wall_clock_time", nullable=true)
    private Integer wallclockTime = null;
    @Column(name="ram_mem", nullable=true)
    private Double ramMemory = null;
    @Column(name="flow_id", nullable=true)
    private String flowId = null;
    @Column(name="flow_version", nullable=true)
    private String flowVersion;
    @Column(name="flow_name", nullable=true)
    private String flowName;
    @Column(name="flow_raw", nullable=true)
    @Lob
    private byte[] flowRaw;
    @Column(name="last_modified_time", nullable=true)
    private LocalDateTime lastModifiedTime = null;
    @Column(name="is_deleted", nullable=false)
    private boolean isDeleted = false;
    @Column(name="job_statushistory_id")
    private long jobStatushistoryId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="job_status", nullable=false)
    private StatusType jobStatus = null;
    @Column(name="status_timestamp", nullable=false)
    private LocalDateTime jobStatusTimestamp = null;
    @Column(name="ja_id")
    private Long jaId;
    @Column(name="algo_id", nullable=false)
    private String algorithmId;
    @Column(name="algo_version", nullable=false)
    private String algorithmVersion;
    @Column(name="algo_name", nullable=false)
    private String algorithmName;
    @Column(name="param_id", nullable=true)
    private String parameterId;
    @Column(name="param_label", nullable=true)
    private String paramLabel;
    @Column(name="param_type", nullable=true)
    private String paramType;
    @Column(name="job_algo_param_id", nullable=true)
    private Long jobAlgoParamId;
    @Column(name="value", nullable=true, length=10000)
    private String paramValue;

    public String getViewId() {
        return this.viewId;
    }

    public Long getId() {
        return this.id;
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getJobOwner() {
        return this.jobOwner;
    }

    public Boolean getAutomaticallyMachineSelection() {
        return this.automaticallyMachineSelection;
    }

    public String getSelectedMachine() {
        return this.selectedMachine;
    }

    public Integer getNumberOfProcesses() {
        return this.numberOfProcesses;
    }

    public Integer getNumberOfProcessesByMachine() {
        return this.numberOfProcessesByMachine;
    }

    public LocalDateTime getSubmissionTime() {
        return this.submissionTime;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public Boolean getMultipleExecution() {
        return this.multipleExecution;
    }

    public JobSpecificationType getJobType() {
        return this.jobType;
    }

    public Integer getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public String getExecutionMachine() {
        return this.executionMachine;
    }

    public LocalDateTime getEndTime() {
        return this.endTime;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public String getGuiltyNodeId() {
        return this.guiltyNodeId;
    }

    public ExitStatus getExitStatus() {
        return this.exitStatus;
    }

    public Double getCpuTime() {
        return this.cpuTime;
    }

    public Integer getWallclockTime() {
        return this.wallclockTime;
    }

    public Double getRamMemory() {
        return this.ramMemory;
    }

    public String getFlowId() {
        return this.flowId;
    }

    public String getFlowVersion() {
        return this.flowVersion;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public byte[] getFlowRaw() {
        return this.flowRaw;
    }

    public LocalDateTime getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public long getJobStatushistoryId() {
        return this.jobStatushistoryId;
    }

    public StatusType getJobStatus() {
        return this.jobStatus;
    }

    public LocalDateTime getJobStatusTimestamp() {
        return this.jobStatusTimestamp;
    }

    public Long getJaId() {
        return this.jaId;
    }

    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public String getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getParameterId() {
        return this.parameterId;
    }

    public String getParamLabel() {
        return this.paramLabel;
    }

    public String getParamType() {
        return this.paramType;
    }

    public Long getJobAlgoParamId() {
        return this.jobAlgoParamId;
    }

    public String getParamValue() {
        return this.paramValue;
    }
}

