package br.pucrio.tecgraf.soma.job.domain.model;

import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;

import javax.persistence.*;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Job Algorithm Entity
 */
@Entity
@Table(name="job_algorithms")
public class JobAlgorithm implements Serializable {

    // Identifier
    @Id
    @GeneratedValue(strategy = GenerationType.SEQUENCE, generator = "job_algorithms_generator")
    @SequenceGenerator(name="job_algorithms_generator", sequenceName = "public.job_algorithms_seq", allocationSize=1)
    @Column(name = "id", updatable = false, nullable = false)
    private Long id;

    // The algorithm identification
    @Column(name="algo_id", nullable=false)
    private String algorithmId;

    // The algorithm version
    @Column(name="algo_version", nullable=false)
    private String algorithmVersion;

    // The algorithm name
    @Column(name="algo_name", nullable=false)
    private String algorithmName;

    // The algorithm name
    @Column(name="flow_node_id", nullable=true)
    private int flowNodeId;

    @ManyToOne
    @JoinColumn(name="job_id", nullable=false)
    private Job job;

    // The list of parameters used
    @OneToMany(mappedBy="jobAlgorithm", fetch = FetchType.EAGER, cascade = CascadeType.ALL, orphanRemoval = true)
    @Fetch(value = FetchMode.SUBSELECT)
    private List<JobAlgorithmParameter> parameters = new ArrayList<JobAlgorithmParameter>();

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAlgorithmId() {
        return algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public String getAlgorithmVersion() {
        return algorithmVersion;
    }

    public void setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public String getAlgorithmName() {
        return algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public int getFlowNodeId() {
        return flowNodeId;
    }

    public void setFlowNodeId(int flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public Job getJob() {
        return job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public List<JobAlgorithmParameter> getParameters() {
        return parameters;
    }

    public void addParameter(JobAlgorithmParameter parameter) {
        parameter.setJobAlgorithm(this);
        this.parameters.add(parameter);
    }
}
