/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.command;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;
import org.apache.avro.data.RecordBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.message.BinaryMessageDecoder;
import org.apache.avro.message.BinaryMessageEncoder;
import org.apache.avro.message.SchemaStore;
import org.apache.avro.specific.AvroGenerated;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class CommandHistoryEvent
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = 3569028058879838965L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"CommandHistoryEvent\",\"namespace\":\"br.pucrio.tecgraf.soma.command\",\"doc\":\"Avro Schema for the command history events.\",\"fields\":[{\"name\":\"eventName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The name of the event\",\"default\":\"UNKNOWN\"},{\"name\":\"event\",\"type\":[{\"type\":\"record\",\"name\":\"AnyCommandEvent\",\"doc\":\"Avro Schema for default command event.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The event timestamp\",\"default\":0},{\"name\":\"commandId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the command\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"CommandScheduledEvent\",\"doc\":\"Avro Schema for the event of command scheduled. All the information came from the command submission.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The command event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The command event timestamp\",\"default\":0},{\"name\":\"commandId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the command\",\"default\":\"\"},{\"name\":\"groupId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Command group identifier\",\"default\":\"\"},{\"name\":\"projectId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Project identifier\",\"default\":\"\"},{\"name\":\"owner\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"Owner's user identifier\",\"default\":\"\"},{\"name\":\"automaticallyMachineSelection\",\"type\":\"boolean\",\"doc\":\"Flag to indicate option for automatically machine selection\",\"default\":false},{\"name\":\"selectedMachines\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"string\",\"avro.java.string\":\"String\"}},\"doc\":\"Machines that user selected for execution.\",\"default\":[]},{\"name\":\"numberOfProcesses\",\"type\":\"int\",\"doc\":\"The total number of processes. In the case of multiple execution, this number can be more than one.\",\"default\":1},{\"name\":\"numberOfProcessesByMachine\",\"type\":\"int\",\"doc\":\"The number of processes by machine. In the case of multiple execution, this number can be more than one.\",\"default\":1},{\"name\":\"submissionTime\",\"type\":\"long\",\"doc\":\"The timestamp of command submission.\",\"default\":0},{\"name\":\"description\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The command description.\",\"default\":\"\"},{\"name\":\"priority\",\"type\":\"int\",\"doc\":\"Execution priority.\",\"default\":0},{\"name\":\"multipleExecution\",\"type\":\"boolean\",\"doc\":\"If the submission will create multiple commands.\",\"default\":false},{\"name\":\"specificationType\",\"type\":{\"type\":\"enum\",\"name\":\"SpecificationType\",\"symbols\":[\"ALGORITHM\",\"FLOW\"]},\"default\":\"ALGORITHM\"},{\"name\":\"specification\",\"type\":[{\"type\":\"record\",\"name\":\"Algorithm\",\"doc\":\"Avro Schema for algorithm parameters.\",\"fields\":[{\"name\":\"algorithmId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm identifier.\",\"default\":\"\"},{\"name\":\"algorithmVersion\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm version.\",\"default\":\"\"},{\"name\":\"algorithmName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The algorithm name.\",\"default\":\"\"},{\"name\":\"parameters\",\"type\":{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"AlgorithmParameter\",\"doc\":\"Avro Schema for algorithm parameter.\",\"fields\":[{\"name\":\"parameterId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter identificator.\",\"default\":\"\"},{\"name\":\"label\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter label.\",\"default\":\"\"},{\"name\":\"type\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The parameter type.\",\"default\":\"\"},{\"name\":\"value\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"The parameter value.\",\"default\":\"null\"}],\"version\":\"1\"}},\"doc\":\"The algorithm parameters.\",\"default\":[]}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"Flow\",\"fields\":[{\"name\":\"flowId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow identifier.\",\"default\":\"\"},{\"name\":\"flowVersion\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow version.\",\"default\":\"\"},{\"name\":\"flowName\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The flow name.\",\"default\":\"\"},{\"name\":\"raw\",\"type\":\"bytes\",\"doc\":\"The flow raw configurator.\",\"default\":\"\"},{\"name\":\"algorithms\",\"type\":{\"type\":\"array\",\"items\":\"Algorithm\"},\"doc\":\"The parameters for each algorithm in the flow.\",\"default\":[]}],\"version\":\"1\"}],\"doc\":\"If the command is related to an algorithm or to a flow.\",\"default\":\"br.pucrio.tecgraf.soma.command.Algorithm\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"CommandStageInEvent\",\"doc\":\"Avro Schema for the event of stage-in.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The command event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The command event timestamp\",\"default\":0},{\"name\":\"commandId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the command\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"CommandStageOutEvent\",\"doc\":\"Avro Schema for the event of stage-out.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The command event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The command event timestamp\",\"default\":0},{\"name\":\"commandId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the command\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"CommandRescheduledEvent\",\"doc\":\"Avro Schema for the event of command re-scheduled.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The command event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The command event timestamp\",\"default\":0},{\"name\":\"commandId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the command\",\"default\":\"\"},{\"name\":\"numberOfRetries\",\"type\":\"int\",\"doc\":\"The number of times the command has already being re-schedule. This value is updated by each re-schedule event.\",\"default\":0}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"CommandExecutingEvent\",\"doc\":\"Avro Schema for executing command event\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The command event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The command event timestamp\",\"default\":0},{\"name\":\"commandId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the command\",\"default\":\"\"},{\"name\":\"executionMachine\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The machine where the command is executing.\",\"default\":\"\"}],\"version\":\"1\"},{\"type\":\"record\",\"name\":\"CommandFinishedEvent\",\"doc\":\"Avro Schema for the event of command finished.\",\"fields\":[{\"name\":\"eventId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The command event identifier\",\"default\":\"\"},{\"name\":\"timestamp\",\"type\":\"long\",\"doc\":\"The command event timestamp\",\"default\":0},{\"name\":\"commandId\",\"type\":{\"type\":\"string\",\"avro.java.string\":\"String\"},\"doc\":\"The identification of the command\",\"default\":\"\"},{\"name\":\"exitCode\",\"type\":[\"null\",\"int\"],\"doc\":\"The command exit code.\",\"default\":null},{\"name\":\"guiltyNodeId\",\"type\":[\"null\",\"int\"],\"doc\":\"The id of the algorithm (flow node) that caused the command finishs earlier than expected.\",\"default\":null},{\"name\":\"exitStatus\",\"type\":{\"type\":\"enum\",\"name\":\"ExitStatus\",\"doc\":\"The possible values for finished command status.\",\"symbols\":[\"UNKNOWN\",\"SUCCESS\",\"EXECUTION_ERROR\",\"COMMAND_IDENTIFIER_NOT_FOUND\",\"UNEXPECTED_MACHINE_ERROR\",\"PROJECT_NOT_FOUND\",\"FAILED_SETUP_EXECUTION_ENVIRONMENT\",\"NO_PERMISSION\",\"NO_MACHINE_AVAILABLE\",\"KILLED\",\"LOST\",\"UNDEFINED\"],\"version\":\"1\"},\"doc\":\"The status of the command after execution.\",\"default\":\"UNKNOWN\"},{\"name\":\"wallclockTime\",\"type\":\"long\",\"doc\":\"The actual amount of time taken to run the command.\",\"default\":0},{\"name\":\"cpuTime\",\"type\":\"long\",\"doc\":\"The amount of time for which a CPU was used ", new String[]{"for processing the command.\",\"default\":0},{\"name\":\"endTime\",\"type\":\"long\",\"doc\":\"The timestamp when the command finished\",\"default\":0}],\"version\":\"1\"}],\"default\":\"br.pucrio.tecgraf.soma.command.AnyCommandEvent\"}],\"version\":\"1\"}"});
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<CommandHistoryEvent> ENCODER = new BinaryMessageEncoder((GenericData)MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<CommandHistoryEvent> DECODER = new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$);
    @Deprecated
    public String eventName;
    @Deprecated
    public Object event;
    private static final DatumWriter<CommandHistoryEvent> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<CommandHistoryEvent> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageDecoder<CommandHistoryEvent> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<CommandHistoryEvent> createDecoder(SchemaStore resolver) {
        return new BinaryMessageDecoder((GenericData)MODEL$, SCHEMA$, resolver);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode((Object)this);
    }

    public static CommandHistoryEvent fromByteBuffer(ByteBuffer b) throws IOException {
        return (CommandHistoryEvent)((Object)DECODER.decode(b));
    }

    public CommandHistoryEvent() {
    }

    public CommandHistoryEvent(String eventName, Object event) {
        this.eventName = eventName;
        this.event = event;
    }

    public Schema getSchema() {
        return SCHEMA$;
    }

    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.eventName;
            }
            case 1: {
                return this.event;
            }
        }
        throw new AvroRuntimeException("Bad index");
    }

    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.eventName = (String)value$;
                break;
            }
            case 1: {
                this.event = value$;
                break;
            }
            default: {
                throw new AvroRuntimeException("Bad index");
            }
        }
    }

    public String getEventName() {
        return this.eventName;
    }

    public void setEventName(String value) {
        this.eventName = value;
    }

    public Object getEvent() {
        return this.event;
    }

    public void setEvent(Object value) {
        this.event = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        return new Builder(other);
    }

    public static Builder newBuilder(CommandHistoryEvent other) {
        return new Builder(other);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write((Object)this, (Encoder)SpecificData.getEncoder((ObjectOutput)out));
    }

    public void readExternal(ObjectInput in) throws IOException {
        READER$.read((Object)this, (Decoder)SpecificData.getDecoder((ObjectInput)in));
    }

    public static class Builder
    extends SpecificRecordBuilderBase<CommandHistoryEvent>
    implements RecordBuilder<CommandHistoryEvent> {
        private String eventName;
        private Object event;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super((SpecificRecordBuilderBase)other);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.eventName)) {
                this.eventName = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.eventName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.event)) {
                this.event = this.data().deepCopy(this.fields()[1].schema(), other.event);
                this.fieldSetFlags()[1] = true;
            }
        }

        private Builder(CommandHistoryEvent other) {
            super(SCHEMA$);
            if (Builder.isValidValue((Schema.Field)this.fields()[0], (Object)other.eventName)) {
                this.eventName = (String)this.data().deepCopy(this.fields()[0].schema(), (Object)other.eventName);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue((Schema.Field)this.fields()[1], (Object)other.event)) {
                this.event = this.data().deepCopy(this.fields()[1].schema(), other.event);
                this.fieldSetFlags()[1] = true;
            }
        }

        public String getEventName() {
            return this.eventName;
        }

        public Builder setEventName(String value) {
            this.validate(this.fields()[0], value);
            this.eventName = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasEventName() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearEventName() {
            this.eventName = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public Object getEvent() {
            return this.event;
        }

        public Builder setEvent(Object value) {
            this.validate(this.fields()[1], value);
            this.event = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasEvent() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearEvent() {
            this.event = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public CommandHistoryEvent build() {
            try {
                CommandHistoryEvent record = new CommandHistoryEvent();
                record.eventName = this.fieldSetFlags()[0] ? this.eventName : (String)this.defaultValue(this.fields()[0]);
                record.event = this.fieldSetFlags()[1] ? this.event : this.defaultValue(this.fields()[1]);
                return record;
            }
            catch (Exception e) {
                throw new AvroRuntimeException((Throwable)e);
            }
        }
    }
}

