/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.hbm;

import org.hibernate.boot.MappingException;
import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmFetchProfileType;
import org.hibernate.boot.model.source.internal.hbm.HbmLocalMetadataBuildingContext;
import org.hibernate.mapping.FetchProfile;
import org.hibernate.mapping.MetadataSource;
import org.jboss.logging.Logger;

public class FetchProfileBinder {
    private static final Logger log = Logger.getLogger(FetchProfileBinder.class);

    public static void processFetchProfile(HbmLocalMetadataBuildingContext context, JaxbHbmFetchProfileType fetchProfileBinding) {
        FetchProfileBinder.processFetchProfile(context, fetchProfileBinding, null);
    }

    public static void processFetchProfile(HbmLocalMetadataBuildingContext context, JaxbHbmFetchProfileType fetchProfileBinding, String containingEntityName) {
        FetchProfile profile2 = context.getMetadataCollector().getFetchProfile(fetchProfileBinding.getName());
        if (profile2 == null) {
            log.debugf("Creating FetchProfile : %s", (Object)fetchProfileBinding.getName());
            profile2 = new FetchProfile(fetchProfileBinding.getName(), MetadataSource.HBM);
            context.getMetadataCollector().addFetchProfile(profile2);
        }
        for (JaxbHbmFetchProfileType.JaxbHbmFetch fetchBinding : fetchProfileBinding.getFetch()) {
            String entityName = fetchBinding.getEntity();
            if (entityName == null) {
                entityName = containingEntityName;
            }
            if (entityName == null) {
                throw new MappingException(String.format("Unable to determine entity for fetch-profile fetch [%s:%s]", profile2.getName(), fetchBinding.getAssociation()), context.getOrigin());
            }
            profile2.addFetch(entityName, fetchBinding.getAssociation(), fetchBinding.getStyle().value());
        }
    }
}

