/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.criteria.expression;

import java.io.Serializable;
import javax.persistence.criteria.Expression;
import org.hibernate.jpa.criteria.CriteriaBuilderImpl;
import org.hibernate.jpa.criteria.ParameterContainer;
import org.hibernate.jpa.criteria.ParameterRegistry;
import org.hibernate.jpa.criteria.Renderable;
import org.hibernate.jpa.criteria.compile.RenderingContext;
import org.hibernate.jpa.criteria.expression.ExpressionImpl;
import org.hibernate.jpa.criteria.expression.LiteralExpression;

public class NullifExpression<T>
extends ExpressionImpl<T>
implements Serializable {
    private final Expression<? extends T> primaryExpression;
    private final Expression<?> secondaryExpression;

    public NullifExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Expression<? extends T> primaryExpression, Expression<?> secondaryExpression) {
        super(criteriaBuilder, NullifExpression.determineType(javaType, primaryExpression));
        this.primaryExpression = primaryExpression;
        this.secondaryExpression = secondaryExpression;
    }

    public NullifExpression(CriteriaBuilderImpl criteriaBuilder, Class<T> javaType, Expression<? extends T> primaryExpression, Object secondaryExpression) {
        super(criteriaBuilder, NullifExpression.determineType(javaType, primaryExpression));
        this.primaryExpression = primaryExpression;
        this.secondaryExpression = new LiteralExpression<Object>(criteriaBuilder, secondaryExpression);
    }

    private static Class determineType(Class javaType, Expression primaryExpression) {
        return javaType != null ? javaType : primaryExpression.getJavaType();
    }

    public Expression<? extends T> getPrimaryExpression() {
        return this.primaryExpression;
    }

    public Expression<?> getSecondaryExpression() {
        return this.secondaryExpression;
    }

    @Override
    public void registerParameters(ParameterRegistry registry) {
        ParameterContainer.Helper.possibleParameter(this.getPrimaryExpression(), registry);
        ParameterContainer.Helper.possibleParameter(this.getSecondaryExpression(), registry);
    }

    @Override
    public String render(RenderingContext renderingContext) {
        return "nullif(" + ((Renderable)((Object)this.getPrimaryExpression())).render(renderingContext) + ',' + ((Renderable)((Object)this.getSecondaryExpression())).render(renderingContext) + ")";
    }

    @Override
    public String renderProjection(RenderingContext renderingContext) {
        return this.render(renderingContext);
    }
}

