/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.convert.internal;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import org.hibernate.metamodel.model.convert.spi.EnumValueConverter;
import org.hibernate.type.descriptor.java.EnumJavaTypeDescriptor;
import org.jboss.logging.Logger;

public class NamedEnumValueConverter<E extends Enum>
implements EnumValueConverter<E, String>,
Serializable {
    private static final Logger log = Logger.getLogger(NamedEnumValueConverter.class);
    private final EnumJavaTypeDescriptor<E> enumJavaDescriptor;

    public NamedEnumValueConverter(EnumJavaTypeDescriptor<E> enumJavaDescriptor) {
        this.enumJavaDescriptor = enumJavaDescriptor;
    }

    @Override
    public E toDomainValue(String relationalForm) {
        return this.enumJavaDescriptor.fromName(relationalForm);
    }

    @Override
    public String toRelationalValue(E domainForm) {
        return this.enumJavaDescriptor.toName(domainForm);
    }

    @Override
    public int getJdbcTypeCode() {
        return 12;
    }

    @Override
    public EnumJavaTypeDescriptor<E> getJavaDescriptor() {
        return this.enumJavaDescriptor;
    }

    @Override
    public E readValue(ResultSet resultSet, String name) throws SQLException {
        String value = resultSet.getString(name);
        boolean traceEnabled = log.isTraceEnabled();
        if (resultSet.wasNull()) {
            if (traceEnabled) {
                log.trace(String.format("Returning null as column [%s]", name));
            }
            return null;
        }
        E enumValue = this.toDomainValue(value);
        if (traceEnabled) {
            log.trace(String.format("Returning [%s] as column [%s]", enumValue, name));
        }
        return enumValue;
    }

    @Override
    public void writeValue(PreparedStatement statement, E value, int position) throws SQLException {
        String jdbcValue = value == null ? null : this.toRelationalValue(value);
        boolean traceEnabled = log.isTraceEnabled();
        if (jdbcValue == null) {
            if (traceEnabled) {
                log.tracef("Binding null to parameter: [%s]", position);
            }
            statement.setNull(position, this.getJdbcTypeCode());
            return;
        }
        if (traceEnabled) {
            log.tracef("Binding [%s] to parameter: [%s]", (Object)jdbcValue, (Object)position);
        }
        statement.setString(position, jdbcValue);
    }

    @Override
    public String toSqlLiteral(Object value) {
        return String.format(Locale.ROOT, "'%s'", ((Enum)value).name());
    }
}

