/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.security.oauth2.resource;

import java.util.Collection;
import java.util.List;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.AuthorityUtils;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.OAuth2Request;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.UserProfile;
import org.springframework.social.connect.support.OAuth2ConnectionFactory;
import org.springframework.social.oauth2.AccessGrant;

public class SpringSocialTokenServices
implements ResourceServerTokenServices {
    private final OAuth2ConnectionFactory<?> connectionFactory;
    private final String clientId;

    public SpringSocialTokenServices(OAuth2ConnectionFactory<?> connectionFactory, String clientId) {
        this.connectionFactory = connectionFactory;
        this.clientId = clientId;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        AccessGrant accessGrant = new AccessGrant(accessToken);
        Connection connection = this.connectionFactory.createConnection(accessGrant);
        UserProfile user = connection.fetchUserProfile();
        return this.extractAuthentication(user);
    }

    private OAuth2Authentication extractAuthentication(UserProfile user) {
        String principal = user.getUsername();
        List authorities = AuthorityUtils.commaSeparatedStringToAuthorityList((String)"ROLE_USER");
        OAuth2Request request = new OAuth2Request(null, this.clientId, null, true, null, null, null, null, null);
        return new OAuth2Authentication(request, (Authentication)new UsernamePasswordAuthenticationToken((Object)principal, (Object)"N/A", (Collection)authorities));
    }

    public OAuth2AccessToken readAccessToken(String accessToken) {
        throw new UnsupportedOperationException("Not supported: read access token");
    }
}

