/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class JpaSort
extends Sort {
    private static final long serialVersionUID = 1L;

    public JpaSort(Attribute<?, ?> ... attributes) {
        this(DEFAULT_DIRECTION, attributes);
    }

    public JpaSort(Path<?, ?> ... paths) {
        this(DEFAULT_DIRECTION, paths);
    }

    public JpaSort(Sort.Direction direction, Attribute<?, ?> ... attributes) {
        this(direction, JpaSort.paths(attributes));
    }

    public JpaSort(Sort.Direction direction, Path<?, ?> ... paths) {
        this(direction, Arrays.asList(paths));
    }

    private JpaSort(Sort.Direction direction, List<Path<?, ?>> paths) {
        this(Collections.emptyList(), direction, paths);
    }

    private JpaSort(List<Sort.Order> orders, Sort.Direction direction, List<Path<?, ?>> paths) {
        super(JpaSort.combine(orders, direction, paths));
    }

    private JpaSort(List<Sort.Order> orders) {
        super(orders);
    }

    public JpaSort and(Sort.Direction direction, Attribute<?, ?> ... attributes) {
        Assert.notNull(attributes, "Attributes must not be null!");
        return this.and(direction, JpaSort.paths(attributes));
    }

    public JpaSort and(Sort.Direction direction, Path<?, ?> ... paths) {
        Assert.notNull(paths, "Paths must not be null!");
        ArrayList<Sort.Order> existing = new ArrayList<Sort.Order>();
        for (Sort.Order order : this) {
            existing.add(order);
        }
        return new JpaSort(existing, direction, Arrays.asList(paths));
    }

    public JpaSort andUnsafe(Sort.Direction direction, String ... properties) {
        Assert.notEmpty((Object[])properties, "Properties must not be null!");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        for (Sort.Order order : this) {
            orders.add(order);
        }
        for (String property : properties) {
            orders.add(new JpaOrder(direction, property));
        }
        return new JpaSort(orders, direction, Collections.<Path<?, ?>>emptyList());
    }

    private static Path<?, ?>[] paths(Attribute<?, ?>[] attributes) {
        Assert.notNull(attributes, "Attributes must not be null!");
        Assert.isTrue(attributes.length > 0, "Attributes must not be empty");
        Path[] paths = new Path[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            paths[i] = JpaSort.path(attributes[i]);
        }
        return paths;
    }

    private static List<Sort.Order> combine(List<Sort.Order> orders, Sort.Direction direction, List<Path<?, ?>> paths) {
        ArrayList<Sort.Order> result = new ArrayList<Sort.Order>(orders);
        for (Path<?, ?> path : paths) {
            result.add(new Sort.Order(direction, path.toString()));
        }
        return result;
    }

    public static <A extends Attribute<T, S>, T, S> Path<T, S> path(A attribute) {
        Assert.notNull(attribute, "Attribute must not be null!");
        return new Path(Arrays.asList(attribute));
    }

    public static <P extends PluralAttribute<T, ?, S>, T, S> Path<T, S> path(P attribute) {
        Assert.notNull(attribute, "Attribute must not be null!");
        return new Path(Arrays.asList(attribute));
    }

    public static JpaSort unsafe(String ... properties) {
        return JpaSort.unsafe(Sort.DEFAULT_DIRECTION, properties);
    }

    public static JpaSort unsafe(Sort.Direction direction, String ... properties) {
        Assert.notNull((Object)direction, "Direction must not be null!");
        Assert.notEmpty((Object[])properties, "Properties must not be empty!");
        Assert.noNullElements((Object[])properties, "Properties must not contain null values!");
        return JpaSort.unsafe(direction, Arrays.asList(properties));
    }

    public static JpaSort unsafe(Sort.Direction direction, List<String> properties) {
        Assert.notEmpty(properties, "Properties must not be empty!");
        ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
        for (String property : properties) {
            orders.add(new JpaOrder(direction, property));
        }
        return new JpaSort(orders);
    }

    public static class JpaOrder
    extends Sort.Order {
        private static final long serialVersionUID = 1L;
        private final boolean unsafe;
        private final boolean ignoreCase;

        private JpaOrder(Sort.Direction direction, String property) {
            this(direction, property, Sort.NullHandling.NATIVE);
        }

        private JpaOrder(Sort.Direction direction, String property, Sort.NullHandling nullHandlingHint) {
            this(direction, property, nullHandlingHint, false, true);
        }

        private JpaOrder(Sort.Direction direction, String property, Sort.NullHandling nullHandling, boolean ignoreCase, boolean unsafe) {
            super(direction, property, nullHandling);
            this.ignoreCase = ignoreCase;
            this.unsafe = unsafe;
        }

        @Override
        public JpaOrder with(Sort.Direction order) {
            return new JpaOrder(order, this.getProperty(), this.getNullHandling(), this.isIgnoreCase(), this.unsafe);
        }

        @Override
        public JpaOrder with(Sort.NullHandling nullHandling) {
            return new JpaOrder(this.getDirection(), this.getProperty(), nullHandling, this.isIgnoreCase(), this.unsafe);
        }

        public Sort withUnsafe(String ... properties) {
            Assert.notEmpty((Object[])properties, "Properties must not be empty!");
            Assert.noNullElements((Object[])properties, "Properties must not contain null values!");
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            for (String property : properties) {
                orders.add(new JpaOrder(this.getDirection(), property, this.getNullHandling(), this.isIgnoreCase(), this.unsafe));
            }
            return new Sort(orders);
        }

        @Override
        public JpaOrder ignoreCase() {
            return new JpaOrder(this.getDirection(), this.getProperty(), this.getNullHandling(), true, this.unsafe);
        }

        @Override
        public boolean isIgnoreCase() {
            return super.isIgnoreCase() || this.ignoreCase;
        }

        public boolean isUnsafe() {
            return this.unsafe;
        }
    }

    public static class Path<T, S> {
        private final Collection<Attribute<?, ?>> attributes;

        private Path(List<? extends Attribute<?, ?>> attributes) {
            this.attributes = Collections.unmodifiableList(attributes);
        }

        public <A extends Attribute<S, U>, U> Path<S, U> dot(A attribute) {
            return new Path<T, S>(this.add(attribute));
        }

        public <P extends PluralAttribute<S, ?, U>, U> Path<S, U> dot(P attribute) {
            return new Path<T, S>(this.add(attribute));
        }

        private List<Attribute<?, ?>> add(Attribute<?, ?> attribute) {
            Assert.notNull(attribute, "Attribute must not be null!");
            ArrayList newAttributes = new ArrayList(this.attributes.size() + 1);
            newAttributes.addAll(this.attributes);
            newAttributes.add(attribute);
            return newAttributes;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            for (Attribute<?, ?> attribute : this.attributes) {
                builder.append(attribute.getName()).append(".");
            }
            return builder.length() == 0 ? "" : builder.substring(0, builder.lastIndexOf("."));
        }
    }
}

