/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import java.io.Serializable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.util.Assert;

public class Specifications<T>
implements Specification<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Specification<T> spec;

    private Specifications(Specification<T> spec) {
        this.spec = spec;
    }

    public static <T> Specifications<T> where(Specification<T> spec) {
        return new Specifications<T>(spec);
    }

    public Specifications<T> and(Specification<T> other) {
        return new Specifications(new ComposedSpecification(this.spec, other, CompositionType.AND));
    }

    public Specifications<T> or(Specification<T> other) {
        return new Specifications(new ComposedSpecification(this.spec, other, CompositionType.OR));
    }

    public static <T> Specifications<T> not(Specification<T> spec) {
        return new Specifications<T>(new NegatedSpecification<T>(spec));
    }

    @Override
    public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
        return this.spec == null ? null : this.spec.toPredicate(root, query, builder);
    }

    private static class ComposedSpecification<T>
    implements Specification<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Specification<T> lhs;
        private final Specification<T> rhs;
        private final CompositionType compositionType;

        private ComposedSpecification(Specification<T> lhs, Specification<T> rhs, CompositionType compositionType) {
            Assert.notNull((Object)compositionType, "CompositionType must not be null!");
            this.lhs = lhs;
            this.rhs = rhs;
            this.compositionType = compositionType;
        }

        @Override
        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
            Predicate thisPredicate;
            Predicate otherPredicate = this.rhs == null ? null : this.rhs.toPredicate(root, query, builder);
            Predicate predicate = thisPredicate = this.lhs == null ? null : this.lhs.toPredicate(root, query, builder);
            return thisPredicate == null ? otherPredicate : (otherPredicate == null ? thisPredicate : this.compositionType.combine(builder, thisPredicate, otherPredicate));
        }
    }

    private static class NegatedSpecification<T>
    implements Specification<T>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Specification<T> spec;

        public NegatedSpecification(Specification<T> spec) {
            this.spec = spec;
        }

        @Override
        public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder builder) {
            return this.spec == null ? null : builder.not(this.spec.toPredicate(root, query, builder));
        }
    }

    static enum CompositionType {
        AND{

            @Override
            public Predicate combine(CriteriaBuilder builder, Predicate lhs, Predicate rhs) {
                return builder.and((Expression<Boolean>)lhs, (Expression<Boolean>)rhs);
            }
        }
        ,
        OR{

            @Override
            public Predicate combine(CriteriaBuilder builder, Predicate lhs, Predicate rhs) {
                return builder.or((Expression<Boolean>)lhs, (Expression<Boolean>)rhs);
            }
        };


        abstract Predicate combine(CriteriaBuilder var1, Predicate var2, Predicate var3);
    }
}

