/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl.binding;

import com.querydsl.core.types.Path;
import java.beans.PropertyDescriptor;
import org.springframework.beans.BeanUtils;
import org.springframework.data.querydsl.EntityPathResolver;
import org.springframework.data.querydsl.QueryDslUtils;
import org.springframework.data.querydsl.binding.PathInformation;

class QuerydslPathInformation
implements PathInformation {
    private final Path<?> path;

    @Override
    public Class<?> getLeafType() {
        return this.path.getType();
    }

    @Override
    public Class<?> getLeafParentType() {
        return this.path.getMetadata().getParent().getType();
    }

    @Override
    public String getLeafProperty() {
        return this.path.getMetadata().getElement().toString();
    }

    @Override
    public PropertyDescriptor getLeafPropertyDescriptor() {
        return BeanUtils.getPropertyDescriptor(this.getLeafParentType(), this.getLeafProperty());
    }

    @Override
    public String toDotPath() {
        return QueryDslUtils.toDotPath(this.path);
    }

    @Override
    public Path<?> reifyPath(EntityPathResolver resolver) {
        return this.path;
    }

    public String toString() {
        return "QuerydslPathInformation(path=" + this.path + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QuerydslPathInformation)) {
            return false;
        }
        QuerydslPathInformation other = (QuerydslPathInformation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Path<?> this$path = this.path;
        Path<?> other$path = other.path;
        return !(this$path == null ? other$path != null : !this$path.equals(other$path));
    }

    protected boolean canEqual(Object other) {
        return other instanceof QuerydslPathInformation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Path<?> $path = this.path;
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    private QuerydslPathInformation(Path<?> path) {
        this.path = path;
    }

    public static QuerydslPathInformation of(Path<?> path) {
        return new QuerydslPathInformation(path);
    }
}

