/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.lob;

import javax.transaction.Synchronization;
import org.springframework.jdbc.support.lob.LobCreator;
import org.springframework.util.Assert;

public class JtaLobCreatorSynchronization
implements Synchronization {
    private final LobCreator lobCreator;
    private boolean beforeCompletionCalled = false;

    public JtaLobCreatorSynchronization(LobCreator lobCreator) {
        Assert.notNull((Object)lobCreator, "LobCreator must not be null");
        this.lobCreator = lobCreator;
    }

    @Override
    public void beforeCompletion() {
        this.beforeCompletionCalled = true;
        this.lobCreator.close();
    }

    @Override
    public void afterCompletion(int status) {
        if (!this.beforeCompletionCalled) {
            this.lobCreator.close();
        }
    }
}

