/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.serializers;

import io.confluent.common.config.AbstractConfig;
import io.confluent.common.config.ConfigDef;
import io.confluent.kafka.serializers.subject.SubjectNameStrategy;
import io.confluent.kafka.serializers.subject.TopicNameStrategy;
import java.util.List;
import java.util.Map;

public class AbstractKafkaAvroSerDeConfig
extends AbstractConfig {
    public static final String SCHEMA_REGISTRY_URL_CONFIG = "schema.registry.url";
    public static final String SCHEMA_REGISTRY_URL_DOC = "Comma-separated list of URLs for schema registry instances that can be used to register or look up schemas.";
    public static final String MAX_SCHEMAS_PER_SUBJECT_CONFIG = "max.schemas.per.subject";
    public static final int MAX_SCHEMAS_PER_SUBJECT_DEFAULT = 1000;
    public static final String MAX_SCHEMAS_PER_SUBJECT_DOC = "Maximum number of schemas to create or cache locally.";
    public static final String AUTO_REGISTER_SCHEMAS = "auto.register.schemas";
    public static final boolean AUTO_REGISTER_SCHEMAS_DEFAULT = true;
    public static final String AUTO_REGISTER_SCHEMAS_DOC = "Specify if the Serializer should attempt to register the Schema with Schema Registry";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE = "basic.auth.credentials.source";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT = "URL";
    public static final String BASIC_AUTH_CREDENTIALS_SOURCE_DOC = "Specify how to pick the credentials for Basic uth header. The supported values are URL, USER_INFO and SASL_INHERIT";
    @Deprecated
    public static final String SCHEMA_REGISTRY_USER_INFO_CONFIG = "schema.registry.basic.auth.user.info";
    public static final String SCHEMA_REGISTRY_USER_INFO_DEFAULT = "";
    public static final String SCHEMA_REGISTRY_USER_INFO_DOC = "Specify the user info for Basic Auth in the form of {username}:{password}";
    public static final String USER_INFO_CONFIG = "basic.auth.user.info";
    public static final String USER_INFO_DEFAULT = "";
    public static final String KEY_SUBJECT_NAME_STRATEGY = "key.subject.name.strategy";
    public static final String KEY_SUBJECT_NAME_STRATEGY_DEFAULT = TopicNameStrategy.class.getName();
    public static final String KEY_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the key schema is registered with the schema registry. By default, <topic>-key is used as subject.";
    public static final String VALUE_SUBJECT_NAME_STRATEGY = "value.subject.name.strategy";
    public static final String VALUE_SUBJECT_NAME_STRATEGY_DEFAULT = TopicNameStrategy.class.getName();
    public static final String VALUE_SUBJECT_NAME_STRATEGY_DOC = "Determines how to construct the subject name under which the value schema is registered with the schema registry. By default, <topic>-value is used as subject.";

    public static ConfigDef baseConfigDef() {
        return new ConfigDef().define(SCHEMA_REGISTRY_URL_CONFIG, ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, SCHEMA_REGISTRY_URL_DOC).define(MAX_SCHEMAS_PER_SUBJECT_CONFIG, ConfigDef.Type.INT, 1000, ConfigDef.Importance.LOW, MAX_SCHEMAS_PER_SUBJECT_DOC).define(AUTO_REGISTER_SCHEMAS, ConfigDef.Type.BOOLEAN, true, ConfigDef.Importance.MEDIUM, AUTO_REGISTER_SCHEMAS_DOC).define(BASIC_AUTH_CREDENTIALS_SOURCE, ConfigDef.Type.STRING, BASIC_AUTH_CREDENTIALS_SOURCE_DEFAULT, ConfigDef.Importance.MEDIUM, BASIC_AUTH_CREDENTIALS_SOURCE_DOC).define(SCHEMA_REGISTRY_USER_INFO_CONFIG, ConfigDef.Type.PASSWORD, "", ConfigDef.Importance.MEDIUM, SCHEMA_REGISTRY_USER_INFO_DOC).define(USER_INFO_CONFIG, ConfigDef.Type.PASSWORD, "", ConfigDef.Importance.MEDIUM, SCHEMA_REGISTRY_USER_INFO_DOC).define(KEY_SUBJECT_NAME_STRATEGY, ConfigDef.Type.CLASS, KEY_SUBJECT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, KEY_SUBJECT_NAME_STRATEGY_DOC).define(VALUE_SUBJECT_NAME_STRATEGY, ConfigDef.Type.CLASS, VALUE_SUBJECT_NAME_STRATEGY_DEFAULT, ConfigDef.Importance.MEDIUM, VALUE_SUBJECT_NAME_STRATEGY_DOC);
    }

    public AbstractKafkaAvroSerDeConfig(ConfigDef config, Map<?, ?> props) {
        super(config, props);
    }

    public int getMaxSchemasPerSubject() {
        return this.getInt(MAX_SCHEMAS_PER_SUBJECT_CONFIG);
    }

    public List<String> getSchemaRegistryUrls() {
        return this.getList(SCHEMA_REGISTRY_URL_CONFIG);
    }

    public boolean autoRegisterSchema() {
        return this.getBoolean(AUTO_REGISTER_SCHEMAS);
    }

    public SubjectNameStrategy keySubjectNameStrategy() {
        return this.getConfiguredInstance(KEY_SUBJECT_NAME_STRATEGY, SubjectNameStrategy.class);
    }

    public SubjectNameStrategy valueSubjectNameStrategy() {
        return this.getConfiguredInstance(VALUE_SUBJECT_NAME_STRATEGY, SubjectNameStrategy.class);
    }

    public String basicAuthUserInfo() {
        String deprecatedValue = this.getString(SCHEMA_REGISTRY_USER_INFO_CONFIG);
        if (deprecatedValue != null && !deprecatedValue.isEmpty()) {
            return deprecatedValue;
        }
        return this.getString(USER_INFO_CONFIG);
    }
}

