/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.persister.entity;

import java.io.Serializable;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.loader.entity.UniqueEntityLoader;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.query.internal.AbstractProducedQuery;

public final class NamedQueryLoader
implements UniqueEntityLoader {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(NamedQueryLoader.class);
    private final String queryName;
    private final EntityPersister persister;
    private final int position;

    public NamedQueryLoader(String queryName, EntityPersister persister) {
        this.queryName = queryName;
        this.persister = persister;
        this.position = persister.getFactory().getSessionFactoryOptions().jdbcStyleParamsZeroBased() ? 0 : 1;
    }

    @Override
    public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session, LockOptions lockOptions) {
        if (lockOptions != null) {
            LOG.debug("Ignoring lock-options passed to named query loader");
        }
        return this.load(id, optionalObject, session);
    }

    @Override
    public Object load(Serializable id, Object optionalObject, SharedSessionContractImplementor session) {
        LOG.debugf("Loading entity: %s using named query: %s", (Object)this.persister.getEntityName(), (Object)this.queryName);
        AbstractProducedQuery query = (AbstractProducedQuery)session.getNamedQuery(this.queryName);
        if (query.getParameterMetadata().hasNamedParameters()) {
            query.setParameter(query.getNamedParameters()[0], (Object)id, this.persister.getIdentifierType());
        } else {
            query.setParameter(this.position, (Object)id, this.persister.getIdentifierType());
        }
        query.setOptionalId(id);
        query.setOptionalEntityName(this.persister.getEntityName());
        query.setOptionalObject(optionalObject);
        query.setFlushMode(FlushMode.MANUAL);
        query.list();
        return session.getPersistenceContext().getEntity(session.generateEntityKey(id, this.persister));
    }
}

