/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.modelmapper.internal.Errors;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

class CalendarConverter
implements ConditionalConverter<Object, Object> {
    private static DatatypeFactory dataTypeFactory;

    CalendarConverter() {
    }

    private static DatatypeFactory getDataTypeFactory() {
        if (dataTypeFactory == null) {
            try {
                dataTypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException e) {
                throw new Errors().addMessage(e, "Failed to create DataTypeFactory required for XMLGregorianCalendar conversion", new Object[0]).toMappingException();
            }
        }
        return dataTypeFactory;
    }

    @Override
    public Object convert(MappingContext<Object, Object> context) {
        Object source = context.getSource();
        if (source == null) {
            return null;
        }
        Class<Object> destinationType = context.getDestinationType();
        if (!Calendar.class.isAssignableFrom(destinationType) && !destinationType.equals(XMLGregorianCalendar.class)) {
            throw new Errors().errorMapping(source, destinationType).toMappingException();
        }
        GregorianCalendar calendar = new GregorianCalendar();
        if (source instanceof Date) {
            calendar.setTimeInMillis(((Date)source).getTime());
        } else if (source instanceof Calendar) {
            Calendar cal = (Calendar)source;
            calendar.setTimeZone(cal.getTimeZone());
            calendar.setTimeInMillis(cal.getTime().getTime());
        } else if (source instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar xmlCal = (XMLGregorianCalendar)source;
            GregorianCalendar cal = xmlCal.toGregorianCalendar();
            calendar.setTimeZone(cal.getTimeZone());
            calendar.setTimeInMillis(cal.getTime().getTime());
        } else if (source instanceof Long) {
            calendar.setTimeInMillis((Long)source);
        }
        return destinationType.equals(XMLGregorianCalendar.class) ? CalendarConverter.getDataTypeFactory().newXMLGregorianCalendar(calendar) : calendar;
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return !(!Calendar.class.isAssignableFrom(destinationType) && destinationType != XMLGregorianCalendar.class || !Date.class.isAssignableFrom(sourceType) && !Calendar.class.isAssignableFrom(sourceType) && sourceType != XMLGregorianCalendar.class && sourceType != Long.class && sourceType != Long.TYPE) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }
}

