/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.internal.converter;

import java.util.Collection;
import java.util.Iterator;
import org.modelmapper.internal.util.Iterables;
import org.modelmapper.internal.util.MappingContextHelper;
import org.modelmapper.spi.ConditionalConverter;
import org.modelmapper.spi.MappingContext;

class CollectionConverter
implements ConditionalConverter<Object, Collection<Object>> {
    CollectionConverter() {
    }

    @Override
    public ConditionalConverter.MatchResult match(Class<?> sourceType, Class<?> destinationType) {
        return Iterables.isIterable(sourceType) && Collection.class.isAssignableFrom(destinationType) ? ConditionalConverter.MatchResult.FULL : ConditionalConverter.MatchResult.NONE;
    }

    @Override
    public Collection<Object> convert(MappingContext<Object, Collection<Object>> context) {
        Object source = context.getSource();
        if (source == null) {
            return null;
        }
        int sourceLength = Iterables.getLength(source);
        Collection<Object> originalDestination = context.getDestination();
        Collection<Object> destination = MappingContextHelper.createCollection(context);
        Class<?> elementType = MappingContextHelper.resolveDestinationGenericType(context);
        int index = 0;
        Iterator<Object> iterator = Iterables.iterator(source);
        while (iterator.hasNext()) {
            Object sourceElement = iterator.next();
            Object element = null;
            if (originalDestination != null) {
                element = Iterables.getElement(originalDestination, index);
            }
            if (sourceElement != null) {
                MappingContext<Object, Object> elementContext = element == null ? context.create(sourceElement, elementType) : context.create(sourceElement, element);
                element = context.getMappingEngine().map(elementContext);
            }
            destination.add(element);
            ++index;
        }
        for (Object element : Iterables.subIterable(originalDestination, sourceLength)) {
            destination.add(element);
        }
        return destination;
    }
}

