/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded;

import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.boot.context.embedded.EmbeddedWebApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class XmlEmbeddedWebApplicationContext
extends EmbeddedWebApplicationContext {
    private final XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader((BeanDefinitionRegistry)((Object)this));

    public XmlEmbeddedWebApplicationContext() {
        this.reader.setEnvironment(this.getEnvironment());
    }

    public XmlEmbeddedWebApplicationContext(Resource ... resources) {
        this.load(resources);
        this.refresh();
    }

    public XmlEmbeddedWebApplicationContext(String ... resourceLocations) {
        this.load(resourceLocations);
        this.refresh();
    }

    public XmlEmbeddedWebApplicationContext(Class<?> relativeClass, String ... resourceNames) {
        this.load(relativeClass, resourceNames);
        this.refresh();
    }

    public void setValidating(boolean validating) {
        this.reader.setValidating(validating);
    }

    public void setEnvironment(ConfigurableEnvironment environment2) {
        super.setEnvironment(environment2);
        this.reader.setEnvironment(this.getEnvironment());
    }

    public final void load(Resource ... resources) {
        this.reader.loadBeanDefinitions(resources);
    }

    public final void load(String ... resourceLocations) {
        this.reader.loadBeanDefinitions(resourceLocations);
    }

    public final void load(Class<?> relativeClass, String ... resourceNames) {
        Resource[] resources = new Resource[resourceNames.length];
        for (int i = 0; i < resourceNames.length; ++i) {
            resources[i] = new ClassPathResource(resourceNames[i], relativeClass);
        }
        this.reader.loadBeanDefinitions(resources);
    }
}

