/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jta.bitronix;

import javax.transaction.TransactionManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.core.Ordered;

public class BitronixDependentBeanFactoryPostProcessor
implements BeanFactoryPostProcessor,
Ordered {
    private static final String[] NO_BEANS = new String[0];
    private int order = Integer.MAX_VALUE;

    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        String[] transactionManagers;
        for (String transactionManager : transactionManagers = beanFactory.getBeanNamesForType(TransactionManager.class, true, false)) {
            this.addTransactionManagerDependencies(beanFactory, transactionManager);
        }
    }

    private void addTransactionManagerDependencies(ConfigurableListableBeanFactory beanFactory, String transactionManager) {
        for (String dependentBeanName : this.getBeanNamesForType(beanFactory, "javax.jms.ConnectionFactory")) {
            beanFactory.registerDependentBean(transactionManager, dependentBeanName);
        }
        for (String dependentBeanName : this.getBeanNamesForType(beanFactory, "javax.sql.DataSource")) {
            beanFactory.registerDependentBean(transactionManager, dependentBeanName);
        }
    }

    private String[] getBeanNamesForType(ConfigurableListableBeanFactory beanFactory, String type) {
        try {
            return beanFactory.getBeanNamesForType(Class.forName(type), true, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return NO_BEANS;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }
}

