/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.provider;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Query;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public abstract class HibernateUtils {
    private static final List<String> TYPES = Arrays.asList("org.hibernate.jpa.HibernateQuery", "org.hibernate.ejb.HibernateQuery");
    private static final Method GET_HIBERNATE_QUERY;
    private static final Class<?> HIBERNATE_QUERY_INTERFACE;
    private static final Method QUERY_STRING_METHOD;

    private HibernateUtils() {
    }

    public static String getHibernateQuery(Object query) {
        if (HIBERNATE_QUERY_INTERFACE != null && QUERY_STRING_METHOD != null && HIBERNATE_QUERY_INTERFACE.isInstance(query)) {
            return (String)String.class.cast(ReflectionUtils.invokeMethod(QUERY_STRING_METHOD, query));
        }
        if (HIBERNATE_QUERY_INTERFACE != null && !HIBERNATE_QUERY_INTERFACE.isInstance(query)) {
            query = ((Query)query).unwrap(HIBERNATE_QUERY_INTERFACE);
        }
        return ((org.hibernate.Query)ReflectionUtils.invokeMethod(GET_HIBERNATE_QUERY, query)).getQueryString();
    }

    static {
        Class<?> type = null;
        Method method = null;
        ClassLoader classLoader = HibernateUtils.class.getClassLoader();
        for (String typeName : TYPES) {
            try {
                type = ClassUtils.forName(typeName, classLoader);
                method = type.getMethod("getHibernateQuery", new Class[0]);
            }
            catch (Exception exception) {}
        }
        GET_HIBERNATE_QUERY = method;
        Class<?> queryInterface = null;
        try {
            queryInterface = ClassUtils.forName("org.hibernate.query.Query", classLoader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HIBERNATE_QUERY_INTERFACE = queryInterface == null ? type : queryInterface;
        QUERY_STRING_METHOD = HIBERNATE_QUERY_INTERFACE == null ? null : ReflectionUtils.findMethod(HIBERNATE_QUERY_INTERFACE, "getQueryString");
    }
}

