/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.querydsl;

import com.querydsl.core.types.Path;
import com.querydsl.core.types.PathMetadata;
import com.querydsl.core.types.PathType;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class QueryDslUtils {
    public static final boolean QUERY_DSL_PRESENT = ClassUtils.isPresent("com.querydsl.core.types.Predicate", QueryDslUtils.class.getClassLoader());

    public static String toDotPath(Path<?> path) {
        return QueryDslUtils.toDotPath(path, "");
    }

    private static String toDotPath(Path<?> path, String tail) {
        if (path == null) {
            return tail;
        }
        PathMetadata metadata = path.getMetadata();
        Path parent = metadata.getParent();
        if (parent == null) {
            return tail;
        }
        if (metadata.getPathType().equals((Object)PathType.DELEGATE)) {
            return QueryDslUtils.toDotPath(parent, tail);
        }
        Object element = metadata.getElement();
        if (element == null || !StringUtils.hasText(element.toString())) {
            return QueryDslUtils.toDotPath(parent, tail);
        }
        return QueryDslUtils.toDotPath(parent, StringUtils.hasText(tail) ? String.format("%s.%s", element, tail) : element.toString());
    }

    private QueryDslUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

