package br.pucrio.tecgraf.soma.job.application.service.job.builder;

import br.pucrio.tecgraf.soma.job.*;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.JobAlgorithmMapper;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.JobAlgorithmParameterMapper;
import br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper.ScheduledJobMapper;
import br.pucrio.tecgraf.soma.job.domain.model.*;

public class ScheduledJobBuilder extends AbstractJobBuilder {

  public void build(Job job, JobScheduledEvent event) {
    ScheduledJobMapper.getInstance().map(event, job);

    if (event.getSpecificationType() == SpecificationType.ALGORITHM) {
      Algorithm algorithm = (Algorithm) event.getSpecification();
      JobAlgorithm jobAlgorithm = convertToJobAlgorithm(algorithm);
      job.addAlgorithm(jobAlgorithm);
    } else {
      Flow flow = (Flow) event.getSpecification();
      setFlowInfo(job, flow);
      for (Algorithm algorithm : flow.getAlgorithms()) {
        JobAlgorithm jobAlgorithm = convertToJobAlgorithm(algorithm);
        job.addAlgorithm(jobAlgorithm);
      }
    }

    JobStatusHistory jobStatusHistory =
        newJobStatusHistory(StatusType.SCHEDULED, event.getTimestamp());
    job.addStatusHistory(jobStatusHistory);
  }

  private void setFlowInfo(Job job, Flow flow) {
    job.setFlowId(flow.getFlowId().toString());
    job.setFlowName(flow.getFlowName().toString());
    job.setFlowVersion(flow.getFlowVersion().toString());
    job.setFlowRaw(flow.getRaw().array());
  }

  private JobAlgorithm convertToJobAlgorithm(Algorithm algorithm) {
    JobAlgorithm jobAlgorithm = new JobAlgorithm();
    JobAlgorithmMapper.getInstance().map(algorithm, jobAlgorithm);
    for (AlgorithmParameter algorithmParameter : algorithm.getParameters()) {
      JobAlgorithmParameter jobAlgorithmParameter = new JobAlgorithmParameter();
      JobAlgorithmParameterMapper.getInstance().map(algorithmParameter, jobAlgorithmParameter);
      jobAlgorithm.addParameter(jobAlgorithmParameter);
    }

    return jobAlgorithm;
  }
}
