package br.pucrio.tecgraf.soma.job.domain.model.mapping.mapper;

import br.pucrio.tecgraf.soma.job.Algorithm;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import org.modelmapper.ModelMapper;
import org.modelmapper.TypeMap;

public class JobAlgorithmMapper {
  private static final String TYPE_MAP_NAME = "AlgorithmToJobAlgorithm";
  private static JobAlgorithmMapper instance;

  private final ModelMapper modelMapper;
  private final TypeMap<Algorithm, JobAlgorithm> typeMap;

  private JobAlgorithmMapper() {
    modelMapper = new ModelMapper();

    modelMapper.getConfiguration().setAmbiguityIgnored(true);
    modelMapper.getConfiguration().setSkipNullEnabled(true);

    typeMap = modelMapper.createTypeMap(Algorithm.class, JobAlgorithm.class, TYPE_MAP_NAME);

    typeMap.addMappings(mapper -> mapper.skip(JobAlgorithm::setJob));
    typeMap.addMappings(mapper -> mapper.skip(JobAlgorithm::setId));
    typeMap.addMappings(mapper -> mapper.skip(JobAlgorithm::setFlowNodeExitCode));
    typeMap.addMappings(mapper -> mapper.skip(JobAlgorithm::setFlowNodeProgress));

    modelMapper.validate();
  }

  public static JobAlgorithmMapper getInstance() {
    if (instance == null) {
      instance = new JobAlgorithmMapper();
    }
    return instance;
  }

  public void map(Algorithm algorithm, JobAlgorithm jobAlgorithm) {
    modelMapper.map(algorithm, jobAlgorithm, TYPE_MAP_NAME);
  }
}
