/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job;

import br.pucrio.tecgraf.soma.job.infrastructure.persistence.message.JobHistoryEventReader;
import br.pucrio.tecgraf.soma.job.menu.Menu;
import br.pucrio.tecgraf.soma.serviceapi.ServiceContext;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@EnableTransactionManagement
@SpringBootApplication(exclude={DataSourceAutoConfiguration.class})
public class SomaJobHistoryConsumer
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(SomaJobHistoryConsumer.class);
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ServiceContext serviceContext;

    public static void main(String[] args) {
        Menu menu = new Menu();
        if (menu.parser(args)) {
            String server = menu.getServer();
            String registry = menu.getRegistry();
            String statusTopic = menu.getStatusTopic();
            String progressTopic = menu.getProgressTopic();
            String group = menu.getGroup();
            String hibernateConfiguration = menu.getHibernateConfiguration();
            if (StringUtils.isNotBlank((CharSequence)hibernateConfiguration)) {
                System.setProperty("hibernate-config", hibernateConfiguration);
            }
            SpringApplication.run(SomaJobHistoryConsumer.class, (String[])new String[]{server, registry, statusTopic, progressTopic, group});
        }
    }

    public void run(ApplicationArguments args) {
        String[] argsFromCommandLine = args.getSourceArgs();
        String server = argsFromCommandLine[0];
        String registry = argsFromCommandLine[1];
        String statusTopic = argsFromCommandLine[2];
        String progressTopic = argsFromCommandLine[3];
        String group = argsFromCommandLine[4];
        JobHistoryEventReader receiver = (JobHistoryEventReader)this.applicationContext.getBean(JobHistoryEventReader.class);
        try {
            receiver.run(server, registry, statusTopic, progressTopic, group);
        }
        catch (IOException | InterruptedException e) {
            logger.error("Error trying to read data from the kafka message queue.", (Throwable)e);
        }
    }
}

