package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;

import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import br.pucrio.tecgraf.soma.job.domain.model.Replica;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;

@Transactional
@Repository
public class ReplicaRepository extends JPARepository<Replica> {
    @PersistenceContext private EntityManager _entityManager;

    @Override
    public Class<Replica> getType() {
        return Replica.class;
    }

    @Override
    public EntityManager getEntityManager() {
        return _entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public Replica findBy(long multiflowId, int lineNumber) {
        EntityManager manager = getEntityManager();
        CriteriaBuilder builder = manager.getCriteriaBuilder();
        CriteriaQuery<Replica> criteria = builder.createQuery(Replica.class);
        Root<Replica> root = criteria.from(Replica.class);
        root.join("multiflow", JoinType.INNER);
        criteria.where(
            builder.and(
                builder.equal(root.get("multiflow"),(multiflowId)),
                builder.equal(root.get("lineNumber"),(lineNumber))
            )
        );

        try {
            return manager.createQuery(criteria).getSingleResult();
        } catch (NoResultException e) {
            return null;
        }
    }

}
