package br.pucrio.tecgraf.soma.job.application.configuration;

import java.util.ArrayList;
import java.util.List;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ConfigurationOption;

public class Constants {

  public enum Config {
    HIBERNATE_CONFIGURATION(new ConfigurationOption('b', "hibernate-config",
        "Comma-separated list of hibernate properties (optional)", true,
        "PROP1=VALUE1,PROP2=VALUE2,...", 1, false, false, null)),

    SERVER_BASE_URL(new ConfigurationOption('s', "server-base-url",
        "Server REST API base URL (required)", true,
        "URL", 1, false, true, null));

    public final ConfigurationOption option;

    private Config(ConfigurationOption configurationOption) {
      this.option = configurationOption;
    }

    public static List<ConfigurationOption> options() {
      List<ConfigurationOption> list = new ArrayList<>();
      for (Config config : values())
        list.add(config.option);
      return list;
    }

  }

}
