/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api.model;

import br.pucrio.tecgraf.soma.job.application.JsonUndefined;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.validation.constraints.Min;

@JsonPropertyOrder(value={"lineNumber", "multiflowId", "jobId"})
@JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=JsonUndefined.class)
public class ReplicaJob {
    public static final String JSON_PROPERTY_LINE_NUMBER = "lineNumber";
    @JsonProperty(value="lineNumber")
    private Integer lineNumber;
    public static final String JSON_PROPERTY_MULTIFLOW_ID = "multiflowId";
    @JsonProperty(value="multiflowId")
    private Long multiflowId;
    public static final String JSON_PROPERTY_JOB_ID = "jobId";
    @JsonProperty(value="jobId")
    private String jobId;

    public ReplicaJob lineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
        return this;
    }

    @JsonProperty(value="lineNumber")
    @ApiModelProperty(value="The replica number.")
    @Min(value=1L)
    public @Min(value=1L) Integer getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(Integer lineNumber) {
        this.lineNumber = lineNumber;
    }

    public ReplicaJob multiflowId(Long multiflowId) {
        this.multiflowId = multiflowId;
        return this;
    }

    @JsonProperty(value="multiflowId")
    @ApiModelProperty(value="The multiflow id.")
    public Long getMultiflowId() {
        return this.multiflowId;
    }

    public void setMultiflowId(Long multiflowId) {
        this.multiflowId = multiflowId;
    }

    public ReplicaJob jobId(String jobId) {
        this.jobId = jobId;
        return this;
    }

    @JsonProperty(value="jobId")
    @ApiModelProperty(value="The job string identifier.")
    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaJob replicaJob = (ReplicaJob)o;
        return Objects.equals(this.lineNumber, replicaJob.lineNumber) && Objects.equals(this.multiflowId, replicaJob.multiflowId) && Objects.equals(this.jobId, replicaJob.jobId);
    }

    public int hashCode() {
        return Objects.hash(this.lineNumber, this.multiflowId, this.jobId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ReplicaJob {\n");
        sb.append("    lineNumber: ").append(this.toIndentedString((Object)this.lineNumber)).append("\n");
        sb.append("    multiflowId: ").append(this.toIndentedString((Object)this.multiflowId)).append("\n");
        sb.append("    jobId: ").append(this.toIndentedString((Object)this.jobId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

