package br.pucrio.tecgraf.soma.websocketnotifier.application.configuration;

import java.util.ArrayList;
import java.util.List;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ConfigurationOption;

public class Constants {

  public enum Config {
    KAFKA_SERVER_ADDRESS(new ConfigurationOption('s', "server", "Kafka server address", true,
        "kafka:9092", 1, false, true, null))

    , KAFKA_SCHEMA_REGISTRY_URL(new ConfigurationOption('r', "schema_registry",
            "Kafka schema registry URL", true, "http://kafka:8081/", 1, false, true, null))

    , KAFKA_KSQLDB_URL(new ConfigurationOption('d', "ksqldb",
            "Kafka KSQL Server", true, "http://ksqldb:8088/", 1, true, false, "http://ksqldb:8088/"))

    , KAFKA_KTABLE(new ConfigurationOption('k', "ktable",
            "Kafka Ktable of websocket notifier", true, "ktable_websocket_notifier", 1, true, false, "ktable_websocket_notifier"))

    , KAFKA_TOPIC(new ConfigurationOption('t', "topics", "Kafka topic", true, "job-events;job-progress-events;forum-server", 1,
            false, true, null))

    , KAFKA_NOTIFICATION_TOPIC(new ConfigurationOption('n', "notification_topic", "Kafka notification topic", true, "websocket_notifier", 1,
            true, false, "websocket-connector"))

    , KAFKA_CONSUMER_GROUP(new ConfigurationOption('g', "groups", "Kafka consumer group (optional)",
        true, "job-events-group;job-progress-events-group;forum-server-group", 1, false, false,
        "job-events-group;job-progress-events-group;forum-server-group"))

    , WEBSOCKET_ENDPOINT(
        new ConfigurationOption('e', "websocket_endpoint", "Websocket Topic Endpoint (optional)",
            true, "/v1/wsconnector", 1, false, false, "/v1/wsconnector"))

    , CSGRID_BASE_URL(new ConfigurationOption('u', "csgrid_base_url", "CSGrid REST API base URL (required)", true, "URL",
            1, false, true, null))

    , CSGRID_PROJECTS_PERMISSION_PATH(
            new ConfigurationOption('p', "csgrid_permission_path", "CSGrid projects permission REST API path",
                    true, "/v1/projects/permissions", 1, false, false, "/v1/projects/permissions"))

    , LAST_EVENTS_MINIMUM_NUMBER(
            new ConfigurationOption('m', "last_events_minimum_numbers", "Minimum number of events for each topic.",
            true, "10;10", 1, true, false, "10;10"));

    public final ConfigurationOption option;

    private Config(ConfigurationOption configurationOption) {
      this.option = configurationOption;
    }

    public static List<ConfigurationOption> options() {
      List<ConfigurationOption> list = new ArrayList<>();
      for (Config config : values())
        list.add(config.option);
      return list;
    }

  }

}
