package br.pucrio.tecgraf.soma.websocketnotifier.application.configuration;

import br.pucrio.tecgraf.soma.websocketnotifier.application.service.SocketHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@EnableWebSocket
public class WebSocketConfig implements WebSocketConfigurer {

  private SocketHandler socketHandler;

  @Autowired
  public WebSocketConfig(SocketHandler socketHandler) {
    this.socketHandler = socketHandler;
  }

  public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
    String endpointUrl = Constants.Config.WEBSOCKET_ENDPOINT.option.getValueName();
    registry.addHandler(getSocketHandler(), endpointUrl).setAllowedOrigins("*");
  }

  @Bean
  public SocketHandler getSocketHandler() {
    if (socketHandler ==  null) {
      this.socketHandler = new SocketHandler();
    }
    return socketHandler;
  }
}
