/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.charts;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.Locale;
import org.jfree.chart.renderer.category.BoxAndWhiskerRenderer;
import org.jfree.data.statistics.DefaultBoxAndWhiskerCategoryDataset;
import umontreal.ssj.charts.SSJCategorySeriesCollection;

public class BoxSeriesCollection
extends SSJCategorySeriesCollection {
    final double BARWIDTH = 0.1;

    public BoxSeriesCollection() {
        this.renderer = new BoxAndWhiskerRenderer();
        this.seriesCollection = new DefaultBoxAndWhiskerCategoryDataset();
        ((BoxAndWhiskerRenderer)this.renderer).setMaximumBarWidth(0.1);
    }

    public BoxSeriesCollection(double[] data, int numPoints) {
        this.renderer = new BoxAndWhiskerRenderer();
        ((BoxAndWhiskerRenderer)this.renderer).setMaximumBarWidth(0.1);
        this.seriesCollection = new DefaultBoxAndWhiskerCategoryDataset();
        DefaultBoxAndWhiskerCategoryDataset tempSeriesCollection = (DefaultBoxAndWhiskerCategoryDataset)this.seriesCollection;
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < numPoints; ++i) {
            list.add(data[i]);
        }
        tempSeriesCollection.add(list, (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(0));
    }

    public BoxSeriesCollection(double[] ... data) {
        this.renderer = new BoxAndWhiskerRenderer();
        this.seriesCollection = new DefaultBoxAndWhiskerCategoryDataset();
        DefaultBoxAndWhiskerCategoryDataset tempSeriesCollection = (DefaultBoxAndWhiskerCategoryDataset)this.seriesCollection;
        for (int i = 0; i < data.length; ++i) {
            if (data[i].length == 0) {
                throw new IllegalArgumentException("Unable to render the plot. data[" + i + "] contains no row");
            }
            ArrayList<Double> list = new ArrayList<Double>();
            for (int j = 0; j < data[i].length - 1; ++j) {
                list.add(data[i][j]);
            }
            tempSeriesCollection.add(list, (Comparable)Integer.valueOf(0), (Comparable)((Object)("Serie " + i)));
            list.clear();
        }
        ((BoxAndWhiskerRenderer)this.renderer).setMaximumBarWidth(0.1);
    }

    public BoxSeriesCollection(DefaultBoxAndWhiskerCategoryDataset data) {
        this.renderer = new BoxAndWhiskerRenderer();
        ((BoxAndWhiskerRenderer)this.renderer).setFillBox(false);
        this.seriesCollection = data;
        ((BoxAndWhiskerRenderer)this.renderer).setMaximumBarWidth(0.1);
    }

    public int add(double[] data) {
        return this.add(data, data.length);
    }

    public int add(double[] data, int numPoints) {
        DefaultBoxAndWhiskerCategoryDataset tempSeriesCollection = (DefaultBoxAndWhiskerCategoryDataset)this.seriesCollection;
        ArrayList<Double> list = new ArrayList<Double>();
        for (int i = 0; i < numPoints; ++i) {
            list.add(data[i]);
        }
        int count = tempSeriesCollection.getColumnCount();
        tempSeriesCollection.add(list, (Comparable)Integer.valueOf(0), (Comparable)((Object)("Serie " + count)));
        return count;
    }

    public String getName(int series) {
        return (String)((Object)((DefaultBoxAndWhiskerCategoryDataset)this.seriesCollection).getColumnKey(series));
    }

    @Override
    public double[] getRangeBounds() {
        double max = 0.0;
        double min = 0.0;
        DefaultBoxAndWhiskerCategoryDataset tempSeriesCollection = (DefaultBoxAndWhiskerCategoryDataset)this.seriesCollection;
        if (tempSeriesCollection.getColumnCount() != 0 && tempSeriesCollection.getRowCount() != 0) {
            max = tempSeriesCollection.getItem(0, 0).getMaxOutlier().doubleValue();
            min = tempSeriesCollection.getItem(0, 0).getMinOutlier().doubleValue();
        }
        for (int i = 0; i < tempSeriesCollection.getRowCount(); ++i) {
            for (int j = 0; j < tempSeriesCollection.getColumnCount(); ++j) {
                max = Math.max(max, tempSeriesCollection.getItem(i, j).getMaxOutlier().doubleValue());
                min = Math.min(min, tempSeriesCollection.getItem(i, j).getMinOutlier().doubleValue());
            }
        }
        double[] retour = new double[]{min, max};
        return retour;
    }

    @Override
    public String toString() {
        Formatter formatter = new Formatter(Locale.US);
        for (int i = 0; i < this.seriesCollection.getRowCount(); ++i) {
            formatter.format(" Series " + i + " : %n", new Object[0]);
            for (int j = 0; j < this.seriesCollection.getColumnCount(); ++j) {
                formatter.format(",%15e%n", this.seriesCollection.getValue(i, j));
            }
        }
        return formatter.toString();
    }

    @Override
    public String toLatex(double YScale, double YShift, double ymin, double ymax) {
        throw new UnsupportedOperationException(" NOT implemented yet");
    }
}

