/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.gof;

import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.probdist.EmpiricalDist;
import umontreal.ssj.randvar.KernelDensityGen;

public class KernelDensity {
    private static double estimate(EmpiricalDist dist, ContinuousDistribution kern, double h, double y) {
        double a = kern.getXinf();
        double b = kern.getXsup();
        double sum = 0.0;
        int n = dist.getN();
        for (int i = 0; i < n; ++i) {
            double z = (y - dist.getObs(i)) / h;
            if (!(z >= a) || !(z <= b)) continue;
            sum += kern.density(z);
        }
        return sum /= h * (double)n;
    }

    public static double[] computeDensity(EmpiricalDist dist, ContinuousDistribution kern, double h, double[] Y) {
        int m = Y.length;
        double[] u = new double[m];
        for (int j = 0; j < m; ++j) {
            u[j] = KernelDensity.estimate(dist, kern, h, Y[j]);
        }
        return u;
    }

    public static double[] computeDensity(EmpiricalDist dist, ContinuousDistribution kern, double[] Y) {
        double h = KernelDensityGen.getBaseBandwidth(dist);
        return KernelDensity.computeDensity(dist, kern, h, Y);
    }
}

