/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.probdist.NegativeBinomialDist;
import umontreal.ssj.util.RootFinder;

public class PascalDist
extends NegativeBinomialDist {
    private static final double EPSI = 1.0E-10;

    public PascalDist(int n, double p) {
        this.setParams(n, p);
    }

    public static double[] getMLE(int[] x, int m) {
        if (m <= 0) {
            throw new IllegalArgumentException("m <= 0");
        }
        double sum = 0.0;
        int max = Integer.MIN_VALUE;
        for (int i = 0; i < m; ++i) {
            sum += (double)x[i];
            if (x[i] <= max) continue;
            max = x[i];
        }
        double mean = sum / (double)m;
        double var = 0.0;
        for (int i = 0; i < m; ++i) {
            var += ((double)x[i] - mean) * ((double)x[i] - mean);
        }
        if (mean >= (var /= (double)m)) {
            throw new UnsupportedOperationException("mean >= variance");
        }
        int[] Fj = new int[max];
        for (int j = 0; j < max; ++j) {
            int prop = 0;
            for (int i = 0; i < m; ++i) {
                if (x[i] <= j) continue;
                ++prop;
            }
            Fj[j] = prop;
        }
        double[] parameters = new double[2];
        Function f = new Function(m, max, mean, Fj);
        parameters[1] = RootFinder.brentDekker(1.0E-10, 0.9999999999, f, 1.0E-5);
        if (parameters[1] >= 1.0) {
            parameters[1] = 0.999999999999999;
        }
        parameters[0] = Math.round(parameters[1] * mean / (1.0 - parameters[1]));
        if (parameters[0] == 0.0) {
            parameters[0] = 1.0;
        }
        return parameters;
    }

    public static PascalDist getInstanceFromMLE(int[] x, int m) {
        double[] parameters = PascalDist.getMLE(x, m);
        return new PascalDist((int)parameters[0], parameters[1]);
    }

    public int getN1() {
        return (int)(this.n + 0.5);
    }

    public void setParams(int n, double p) {
        super.setParams(n, p);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " : n = " + this.getN1() + ", p = " + this.getP();
    }

    private static class Function
    implements MathFunction {
        protected int m;
        protected int max;
        protected double mean;
        protected int[] Fj;

        public Function(int m, int max, double mean, int[] Fj) {
            this.m = m;
            this.max = max;
            this.mean = mean;
            this.Fj = new int[Fj.length];
            System.arraycopy(Fj, 0, this.Fj, 0, Fj.length);
        }

        @Override
        public double evaluate(double p) {
            double sum = 0.0;
            double s = p * this.mean / (1.0 - p);
            for (int j = 0; j < this.max; ++j) {
                sum += (double)this.Fj[j] / (s + (double)j);
            }
            return sum + (double)this.m * Math.log(p);
        }

        public double evaluateN(int n, double p) {
            double sum = 0.0;
            for (int j = 0; j < this.max; ++j) {
                sum += (double)(this.Fj[j] / (n + j));
            }
            return sum + (double)this.m * Math.log(p);
        }
    }
}

