/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.CauchyDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class CauchyGen
extends RandomVariateGen {
    protected double alpha;
    protected double beta;

    public CauchyGen(RandomStream s, double alpha, double beta) {
        super(s, new CauchyDist(alpha, beta));
        this.setParams(alpha, beta);
    }

    public CauchyGen(RandomStream s) {
        this(s, 0.0, 1.0);
    }

    public CauchyGen(RandomStream s, CauchyDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getBeta());
        }
    }

    public static double nextDouble(RandomStream s, double alpha, double beta) {
        return CauchyDist.inverseF(alpha, beta, s.nextDouble());
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    protected void setParams(double alpha, double beta) {
        if (beta <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = alpha;
        this.beta = beta;
    }
}

