/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.push.model.notification;

import cn.jpush.api.push.model.notification.PlatformNotification;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;

public class AndroidNotification
extends PlatformNotification {
    public static final String NOTIFICATION_ANDROID = "android";
    private static final String TITLE = "title";
    private static final String BUILDER_ID = "builder_id";
    private static final String INBOX = "inbox";
    private static final String STYLE = "style";
    private static final String BIG_TEXT = "big_text";
    private static final String BIG_PIC_PATH = "big_pic_path";
    private static final String PRIORITY = "priority";
    private static final String CATEGORY = "category";
    private final String title;
    private final int builderId;
    private int style = 0;
    private String big_text;
    private Object inbox;
    private String big_pic_path;
    private int priority;
    private String category;

    private AndroidNotification(Object alert, String title, int builderId, int style, String bigText, Object inbox, String bigPicPath, int priority, String category, Map<String, String> extras, Map<String, Number> numberExtras, Map<String, Boolean> booleanExtras, Map<String, JsonObject> jsonExtras) {
        super(alert, extras, numberExtras, booleanExtras, jsonExtras);
        this.title = title;
        this.builderId = builderId;
        this.style = style;
        this.big_text = bigText;
        this.inbox = inbox;
        this.big_pic_path = bigPicPath;
        this.priority = priority;
        this.category = category;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static AndroidNotification alert(String alert) {
        return AndroidNotification.newBuilder().setAlert(alert).build();
    }

    @Override
    public String getPlatform() {
        return NOTIFICATION_ANDROID;
    }

    protected Object getInbox() {
        return this.inbox;
    }

    protected void setInbox(Object inbox) {
        this.inbox = inbox;
    }

    @Override
    public JsonElement toJSON() {
        JsonObject json = super.toJSON().getAsJsonObject();
        if (this.builderId > 0) {
            json.add(BUILDER_ID, (JsonElement)new JsonPrimitive((Number)this.builderId));
        }
        if (null != this.title) {
            json.add(TITLE, (JsonElement)new JsonPrimitive(this.title));
        }
        if (0 != this.style) {
            json.add(STYLE, (JsonElement)new JsonPrimitive((Number)this.style));
        }
        if (null != this.big_text) {
            json.add(BIG_TEXT, (JsonElement)new JsonPrimitive(this.big_text));
        }
        if (null != this.inbox && this.inbox instanceof JsonObject) {
            json.add(INBOX, (JsonElement)((JsonObject)this.inbox));
        }
        if (null != this.big_pic_path) {
            json.add(BIG_PIC_PATH, (JsonElement)new JsonPrimitive(this.big_pic_path));
        }
        if (0 != this.priority) {
            json.add(PRIORITY, (JsonElement)new JsonPrimitive((Number)this.priority));
        }
        if (null != this.category) {
            json.add(CATEGORY, (JsonElement)new JsonPrimitive(this.category));
        }
        return json;
    }

    public static class Builder
    extends PlatformNotification.Builder<AndroidNotification, Builder> {
        private String title;
        private int builderId;
        private int style = 0;
        private String big_text;
        private Object inbox;
        private String big_pic_path;
        private int priority;
        private String category;

        @Override
        protected Builder getThis() {
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setBuilderId(int builderId) {
            this.builderId = builderId;
            return this;
        }

        @Override
        public Builder setAlert(Object alert) {
            this.alert = alert;
            return this;
        }

        public Builder setStyle(int style) {
            this.style = style;
            return this;
        }

        public Builder setBigText(String bigText) {
            this.big_text = bigText;
            return this;
        }

        public Builder setBigPicPath(String bigPicPath) {
            this.big_pic_path = bigPicPath;
            return this;
        }

        public Builder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setInbox(Object inbox) {
            if (null == inbox) {
                PlatformNotification.LOG.warn("Null inbox. Throw away it.");
                return this;
            }
            this.inbox = inbox;
            return this;
        }

        @Override
        public AndroidNotification build() {
            return new AndroidNotification(this.alert, this.title, this.builderId, this.style, this.big_text, this.inbox, this.big_pic_path, this.priority, this.category, this.extrasBuilder, this.numberExtrasBuilder, this.booleanExtrasBuilder, this.jsonExtrasBuilder);
        }
    }
}

