/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.service.schema.model.attribute;

import com.alipay.service.schema.exception.ServiceSchemaException;
import com.alipay.service.schema.model.attribute.Attribute;
import com.alipay.service.schema.model.enums.AttrTypeEnum;
import com.alipay.service.schema.model.enums.SchemaErrorEnum;
import com.alipay.service.schema.util.StringUtil;
import com.alipay.service.schema.util.XmlUtils;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;

public class MultiAttribute
extends Attribute {
    private List<String> values = new ArrayList<String>();

    @Override
    public Element toElement() throws ServiceSchemaException {
        Element attributeNode = XmlUtils.createRootElement("attribute");
        if (StringUtil.isEmpty(this.getId())) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_MISS_ID);
        }
        if (this.getType() == null || StringUtil.isEmpty(this.getType().getType())) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_MISS_TYPE, this.getId());
        }
        AttrTypeEnum fieldEnum = AttrTypeEnum.getType(this.getType().getType());
        if (fieldEnum == null) {
            throw new ServiceSchemaException(SchemaErrorEnum.ATTR_TYPE_ERROR, this.getId());
        }
        attributeNode.addAttribute("id", this.getId());
        attributeNode.addAttribute("name", this.getName());
        attributeNode.addAttribute("type", this.getType().getType());
        attributeNode.addAttribute("valueType", this.getValueType().getCode());
        Element valuesNode = XmlUtils.appendElement(attributeNode, "values");
        if (this.values != null && this.values.size() > 0) {
            for (String value : this.values) {
                Element valueNode = XmlUtils.appendElement(valuesNode, "value");
                valueNode.setText(value);
            }
        }
        this.appendRulesElement(attributeNode, this.getRules(), this.getId());
        this.appendOptionsElement(attributeNode, this.getOptions(), this.getId());
        return attributeNode;
    }

    public void addValue(String value) {
        this.values.add(value);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

